/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.defs;

import com.ericsson.ere.constraint.ConstraintHandler;
import com.ericsson.ere.dataset.DataSetFactory;
import com.ericsson.ere.dataset.jump.JumperSupport;
import com.ericsson.ere.defs.DataRepository;
import com.ericsson.ere.defs.RMAClassRepository;
import com.ericsson.ere.defs.ServiceFieldStructure;
import com.ericsson.ere.exception.ServiceDataException;
import com.ericsson.ere.exception.ServiceException;
import com.ericsson.ere.selectiontree.interfaces.SelectionTreeNodeMigrator;
import com.ericsson.ere.selectiontree.mdu.filter.MultiDataUpdateFilterFactory;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.DefaultFieldRepository;
import ericsson.ere.defs.ElementAndContext;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.defs.FieldRepository;
import ericsson.ere.defs.FieldRepositoryWithContext;
import ericsson.ere.defs.FieldRepositoryWrapper;
import ericsson.ere.defs.FieldStructure;
import ericsson.ere.defs.PluginName;
import ericsson.ere.interfaces.Condition;
import ericsson.ere.interfaces.FieldHierarchyNode;
import ericsson.ere.interfaces.XMLInitializable;
import ericsson.ere.management.FieldContext;
import ericsson.ere.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RMAClassRepositoryWithContext
extends RMAClassRepository {
    private final RMAClassRepository myBaseClassRepository;
    private final FieldContext myContext;

    RMAClassRepositoryWithContext(RMAClassRepository classRepository, FieldContext context) {
        this.myBaseClassRepository = classRepository;
        this.myContext = context;
        this.myFieldRepository = new FieldRepositoryWrapper(new FieldRepositoryWithContext(RMAClassRepositoryWithContext.getInnerFieldRepositoryFromClassRepository(this.myBaseClassRepository), context));
    }

    @Override
    public void addServiceProviderAndRatingPlanContextFields(Element definitionRootElement) {
        this.myBaseClassRepository.addServiceProviderAndRatingPlanContextFields(definitionRootElement);
        DefaultFieldRepository repository = new DefaultFieldRepository(definitionRootElement);
        FieldRepositoryWrapper innerFieldRepository = RMAClassRepositoryWithContext.getInnerFieldRepositoryFromClassRepository(this.myBaseClassRepository);
        innerFieldRepository.modifyAndSwapRepository(null, null, null, repository.getFieldContextFields());
        this.myFieldRepository = new FieldRepositoryWrapper(new FieldRepositoryWithContext(innerFieldRepository, this.myContext));
    }

    public List<String> getFieldContextServiceProviders() {
        HashSet<String> serviceProvidersSet = new HashSet<String>();
        Iterator<Map.Entry<String, ElementAndContext>> iterator = this.myBaseClassRepository.getAllServiceProviderContextFields().iterator();
        while (iterator.hasNext()) {
            serviceProvidersSet.add(iterator.next().getKey());
        }
        iterator = this.myBaseClassRepository.getAllRatingPlanContextFields().iterator();
        while (iterator.hasNext()) {
            String ratingPlanKey = iterator.next().getKey();
            String serviceProvider = ratingPlanKey.substring(ratingPlanKey.lastIndexOf("@") + 1);
            serviceProvidersSet.add(serviceProvider);
        }
        ArrayList<String> serviceProviders = new ArrayList<String>(serviceProvidersSet);
        Collections.sort(serviceProviders);
        return serviceProviders;
    }

    public List<String> getFieldContextRatingPlans(String serviceProvider) {
        ArrayList<String> ratingPlans = new ArrayList<String>();
        Iterator<Map.Entry<String, ElementAndContext>> iterator = this.myBaseClassRepository.getAllRatingPlanContextFields().iterator();
        while (iterator.hasNext()) {
            String ratingPlanKey = iterator.next().getKey();
            if (!ratingPlanKey.endsWith("@" + serviceProvider)) continue;
            ratingPlans.add(StringUtil.replaceLast(ratingPlanKey, "@" + serviceProvider, ""));
        }
        Collections.sort(ratingPlans);
        return ratingPlans;
    }

    public FieldRepository getFieldContextFieldRepository(String serviceProviderName) {
        ServiceFieldStructure.StructureElement spStructure = this.myBaseClassRepository.getFieldStructure().getRoot().getNamedChild(serviceProviderName);
        return new FieldContextFieldRepository(spStructure != null ? spStructure.getClassRepository().getFieldRepository() : null);
    }

    public FieldRepository getFieldContextFieldRepository(String serviceProviderName, String ratingPlanName) {
        ServiceFieldStructure.StructureElement spStructure = this.myBaseClassRepository.getFieldStructure().getRoot().getNamedChild(serviceProviderName);
        ServiceFieldStructure.StructureElement rpStructure = this.myBaseClassRepository.getFieldStructure().getRoot().getNamedChild(ratingPlanName + "@" + serviceProviderName);
        return new FieldContextFieldRepository(spStructure != null ? spStructure.getClassRepository().getFieldRepository() : null, rpStructure != null ? rpStructure.getClassRepository().getFieldRepository() : null);
    }

    public boolean hasOtherFieldContextFields() {
        boolean otherFieldContext = false;
        List<String> serviceProviders = this.getFieldContextServiceProviders();
        if (serviceProviders.size() > 1) {
            otherFieldContext = true;
        } else if (serviceProviders.size() == 1) {
            String serviceProvider = serviceProviders.get(0);
            if (this.myContext == null || !serviceProvider.equals(this.myContext.getServiceProviderName())) {
                otherFieldContext = true;
            } else {
                String ratingPlan;
                List<String> ratingPlans = this.getFieldContextRatingPlans(serviceProvider);
                if (ratingPlans.size() > 1) {
                    otherFieldContext = true;
                } else if (ratingPlans.size() == 1 && !(ratingPlan = ratingPlans.get(0)).equals(this.myContext.getRatingPlanName())) {
                    otherFieldContext = true;
                }
            }
        }
        return otherFieldContext;
    }

    @Override
    public void addBaseCondition(PluginName name, List<String> dataType, String classStr, String profileStr, String comment) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addCondition(String fieldName, PluginName condName, String className, String profile, String comment) {
        throw new UnsupportedOperationException();
    }

    @Override
    public FieldDefinition addField(Element fieldElement) {
        return this.myBaseClassRepository.addField(fieldElement);
    }

    @Override
    public synchronized void addFieldDefinition(FieldHierarchyNode field) {
        this.myBaseClassRepository.addFieldDefinition(field);
    }

    @Override
    public synchronized void addFields(List<FieldHierarchyNode> fields) throws IllegalArgumentException {
        this.myBaseClassRepository.addFields(fields);
    }

    @Override
    public List<FieldHierarchyNode> addFieldsFromXml(List<Element> fieldElements) {
        return this.myBaseClassRepository.addFieldsFromXml(fieldElements);
    }

    @Override
    public FieldStructure addFieldStructure(Element fieldStructureElement) {
        return this.myBaseClassRepository.addFieldStructure(fieldStructureElement);
    }

    @Override
    public void addModifier(PluginName name, String className, String profile, String comment) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addNode(String name, String className, String profile) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addTariffStructure(String name, String className, String profile) {
        throw new UnsupportedOperationException();
    }

    @Override
    public XMLInitializable createUtil(String context, String name) throws InstantiationException, IllegalAccessException, ClassNotFoundException, Exception {
        return this.myBaseClassRepository.createUtil(context, name);
    }

    @Override
    public String getAliasForCondition(String condition) {
        return this.myBaseClassRepository.getAliasForCondition(condition);
    }

    @Override
    public String getAliasForModifier(String modifier) {
        return this.myBaseClassRepository.getAliasForModifier(modifier);
    }

    @Override
    public Set<Map.Entry<String, Element>> getAllContexts() {
        return this.myBaseClassRepository.getAllContexts();
    }

    @Override
    public String getBaseConditionAliasOrName(String name) {
        return this.myBaseClassRepository.getBaseConditionAliasOrName(name);
    }

    @Override
    public String getBaseConditionClass(String alias) {
        return this.myBaseClassRepository.getBaseConditionClass(alias);
    }

    @Override
    public Map<String, String> getBaseConditionClasses() {
        return this.myBaseClassRepository.getBaseConditionClasses();
    }

    @Override
    public List<String> getBaseConditionDataType(String alias) {
        return this.myBaseClassRepository.getBaseConditionDataType(alias);
    }

    @Override
    public List<PluginName> getBaseConditionList() {
        return this.myBaseClassRepository.getBaseConditionList();
    }

    @Override
    public String getBaseConditionProfile(String alias) {
        return this.myBaseClassRepository.getBaseConditionProfile(alias);
    }

    @Override
    public ClassRepository getClassRepositoryWithContext(FieldContext context) {
        return this.myBaseClassRepository.getClassRepositoryWithContext(context);
    }

    @Override
    public List<FieldDefinition> getCommonFieldDefinitions() {
        HashSet<FieldDefinition> set = new HashSet<FieldDefinition>();
        for (FieldDefinition field : this.getFieldDefinitions()) {
            if (field.isContextField()) continue;
            set.add(field);
        }
        set.addAll(this.myBaseClassRepository.getCommonFieldDefinitions());
        return new ArrayList<FieldDefinition>(set);
    }

    @Override
    public String getConditionAliasOrName(String name) {
        return this.myBaseClassRepository.getConditionAliasOrName(name);
    }

    @Override
    public Condition getConditionClass(String condName) throws InstantiationException {
        return this.myBaseClassRepository.getConditionClass(condName);
    }

    @Override
    public String getConditionClassName(String name) {
        return this.myBaseClassRepository.getConditionClassName(name);
    }

    @Override
    public String getConditionFieldName(String condName) {
        return this.myBaseClassRepository.getConditionFieldName(condName);
    }

    @Override
    public String getConditionProfileClassName(String name) {
        return this.myBaseClassRepository.getConditionProfileClassName(name);
    }

    @Override
    public PluginName[] getConditionTypeNames() {
        return this.myBaseClassRepository.getConditionTypeNames();
    }

    @Override
    public Map<String, String> getConnectedBaseConditions() {
        return this.myBaseClassRepository.getConnectedBaseConditions();
    }

    @Override
    public Element getContextDefinition(String contextName) {
        return this.myBaseClassRepository.getContextDefinition(contextName);
    }

    @Override
    public String getContextFieldIdentifier() {
        return this.myBaseClassRepository.getContextFieldIdentifier();
    }

    @Override
    public DataRepository getDataRepository() throws ServiceDataException {
        return this.myBaseClassRepository.getDataRepository();
    }

    @Override
    public DataSetFactory getDataSetFactory() {
        return this.myBaseClassRepository.getDataSetFactory();
    }

    @Override
    public Map<String, String> getDefinedConditionField() {
        return this.myBaseClassRepository.getDefinedConditionField();
    }

    @Override
    public List<PluginName> getDefinedConditionList() {
        return this.myBaseClassRepository.getDefinedConditionList();
    }

    @Override
    public Map<String, String> getFieldComments() {
        return this.myBaseClassRepository.getFieldComments();
    }

    @Override
    public FieldDefinition getFieldDefinitionByName(String name) {
        FieldDefinition field = null;
        FieldHierarchyNode fieldHierarchyNode = this.myFieldRepository.getFieldByName(name);
        if (fieldHierarchyNode != null && fieldHierarchyNode.isLeaf()) {
            field = (FieldDefinition)fieldHierarchyNode;
        }
        return field;
    }

    @Override
    public List<FieldDefinition> getFieldDefinitions() {
        return this.myFieldRepository.getTopLevelFieldDefinitions();
    }

    @Override
    public String[] getFieldNamesOfType(int type) {
        ArrayList<String> list = new ArrayList<String>();
        for (FieldDefinition field : this.myFieldRepository.getTopLevelFieldDefinitions()) {
            if (field.getTypedDataType().getTypeIdentifier() != type) continue;
            list.add(field.getFieldName());
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    public FieldRepository getFieldRepository() {
        return this.myFieldRepository;
    }

    @Override
    public Element getFieldsRootElement() {
        return this.myBaseClassRepository.getFieldsRootElement();
    }

    @Override
    public ServiceFieldStructure getFieldStructure() {
        return this.myBaseClassRepository.getFieldStructure();
    }

    @Override
    public String getFieldStructureBaseConditionAliasOrName(String name) {
        return this.myBaseClassRepository.getFieldStructureBaseConditionAliasOrName(name);
    }

    @Override
    public String getFieldStructureBaseConditionClass(String name) {
        return this.myBaseClassRepository.getFieldStructureBaseConditionClass(name);
    }

    @Override
    public List<String> getFieldStructureBaseConditionCollectionTypes(String name) {
        return this.myBaseClassRepository.getFieldStructureBaseConditionCollectionTypes(name);
    }

    @Override
    public String getFieldStructureBaseConditionComment(String name) {
        return this.myBaseClassRepository.getFieldStructureBaseConditionComment(name);
    }

    @Override
    public String getFieldStructureBaseConditionProfile(String name) {
        return this.myBaseClassRepository.getFieldStructureBaseConditionProfile(name);
    }

    @Override
    public List<PluginName> getFieldStructureBaseConditions() {
        return this.myBaseClassRepository.getFieldStructureBaseConditions();
    }

    @Override
    public Object[][] getFieldTableData() {
        return this.getFieldTableData(this.myFieldRepository.getTopLevelFieldDefinitions());
    }

    @Override
    public Map<String, FieldDefinition> getInputFieldDefinitionMap() {
        return this.convertFieldListToMap(this.getInputFieldDefinitions());
    }

    @Override
    public List<FieldDefinition> getInputFieldDefinitions() {
        return this.getFieldDefinitionsOfType(INPUT_TYPES);
    }

    private List<FieldDefinition> getFieldDefinitionsOfType(String[] parameterTypes) {
        ArrayList<FieldDefinition> list = new ArrayList<FieldDefinition>();
        block0: for (FieldDefinition field : this.myFieldRepository.getTopLevelFieldDefinitions()) {
            for (String type : parameterTypes) {
                if (!type.equals(field.getParameterType())) continue;
                list.add(field);
                continue block0;
            }
        }
        return list;
    }

    @Override
    public JumperSupport getJumperSupport() {
        return this.myBaseClassRepository.getJumperSupport();
    }

    @Override
    public MultiDataUpdateFilterFactory getMDUFilterFactory() throws ServiceException {
        return this.myBaseClassRepository.getMDUFilterFactory();
    }

    @Override
    public SelectionTreeNodeMigrator getMigrator() {
        return this.myBaseClassRepository.getMigrator();
    }

    @Override
    public String getModifierAliasOrName(String name) {
        return this.myBaseClassRepository.getModifierAliasOrName(name);
    }

    @Override
    public String getModifierClassName(String name) {
        return this.myBaseClassRepository.getModifierClassName(name);
    }

    @Override
    public String getModifierComment(String name) {
        return this.myBaseClassRepository.getModifierComment(name);
    }

    @Override
    public List<PluginName> getModifierList() {
        return this.myBaseClassRepository.getModifierList();
    }

    @Override
    public String getModifierProfileClassName(String name) {
        return this.myBaseClassRepository.getModifierProfileClassName(name);
    }

    @Override
    public String[] getModifierTypeNames() {
        return this.myBaseClassRepository.getModifierTypeNames();
    }

    @Override
    public String getNodeTypeClassName(String name) {
        return this.myBaseClassRepository.getNodeTypeClassName(name);
    }

    @Override
    public String[] getNodeTypeNames() {
        return this.myBaseClassRepository.getNodeTypeNames();
    }

    @Override
    public String getNodeTypeProfileClassName(String name) {
        return this.myBaseClassRepository.getNodeTypeProfileClassName(name);
    }

    @Override
    public String[] getNumericFieldNames() {
        ArrayList<String> list = new ArrayList<String>();
        for (FieldDefinition field : this.myFieldRepository.getTopLevelFieldDefinitions()) {
            if (!field.getTypedDataType().isNumeric()) continue;
            list.add(field.getFieldName());
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    public Map<String, FieldDefinition> getOutputFieldDefinitionMap() {
        return this.convertFieldListToMap(this.getOutputFieldDefinitions());
    }

    @Override
    public List<FieldDefinition> getOutputFieldDefinitions() {
        return this.getFieldDefinitionsOfType(OUTPUT_TYPES);
    }

    @Override
    public String getServiceName() {
        return this.myBaseClassRepository.getServiceName();
    }

    @Override
    public Object getSimulationFactory() {
        return this.myBaseClassRepository.getSimulationFactory();
    }

    @Override
    public String getTariffStructureClassName(String name) {
        return this.myBaseClassRepository.getTariffStructureClassName(name);
    }

    @Override
    public String[] getTariffStructureNames() {
        return this.myBaseClassRepository.getTariffStructureNames();
    }

    @Override
    public String getTariffStructureProfileClassName(String name) {
        return this.myBaseClassRepository.getTariffStructureProfileClassName(name);
    }

    @Override
    public Object getTreeRootObject() {
        return this.myBaseClassRepository.getTreeRootObject();
    }

    @Override
    public NodeList getUtilDefinitions() {
        return this.myBaseClassRepository.getUtilDefinitions();
    }

    @Override
    public NodeList getUtilDefinitions(String level) {
        return this.myBaseClassRepository.getUtilDefinitions(level);
    }

    @Override
    public List<FieldDefinition> getWorkingParameterFields() {
        return this.myBaseClassRepository.getWorkingParameterFields();
    }

    @Override
    public void init(Document definitionDoc) throws Exception {
        this.myBaseClassRepository.init(definitionDoc);
    }

    @Override
    public void init(Document definitionDocument, Document conditionDocumentDoc) throws Exception {
        this.myBaseClassRepository.init(definitionDocument, conditionDocumentDoc);
    }

    @Override
    public void init(Element definitionRootElement) throws Exception {
        this.myBaseClassRepository.init(definitionRootElement);
    }

    @Override
    public void init(Element definitionRootElement, Element conditionRootElement) throws Exception {
        this.myBaseClassRepository.init(definitionRootElement, conditionRootElement);
    }

    @Override
    public boolean isConditionAlias(String nameOrAlias) {
        return this.myBaseClassRepository.isConditionAlias(nameOrAlias);
    }

    @Override
    public boolean isModifierAlias(String nameOrAlias) {
        return this.myBaseClassRepository.isModifierAlias(nameOrAlias);
    }

    @Override
    public boolean isUsingDataSet() {
        return this.myBaseClassRepository.isUsingDataSet();
    }

    @Override
    public synchronized void removeAllTreeDefinedFields() {
        this.myBaseClassRepository.removeAllTreeDefinedFields();
    }

    @Override
    public synchronized FieldHierarchyNode removeField(String name) {
        return this.myBaseClassRepository.removeField(name);
    }

    @Override
    public synchronized List<FieldHierarchyNode> removeFields(List<String> fieldNames) throws IllegalArgumentException {
        return this.myBaseClassRepository.removeFields(fieldNames);
    }

    @Override
    public void removeTreeDefinedField(String name) {
        this.myBaseClassRepository.removeTreeDefinedField(name);
    }

    @Override
    public void setDataSetFactory(DataSetFactory factory) {
        this.myBaseClassRepository.setDataSetFactory(factory);
    }

    @Override
    public void setDefinedConditionList(List<PluginName> pdefinedConditionList) {
        this.myBaseClassRepository.setDefinedConditionList(pdefinedConditionList);
    }

    @Override
    public void setJumperSupport(JumperSupport jumper) {
        this.myBaseClassRepository.setJumperSupport(jumper);
    }

    @Override
    public void setTreeRootObject(Object root) {
        this.myBaseClassRepository.setTreeRootObject(root);
    }

    @Override
    public ConstraintHandler getConstraintHandler() {
        return this.myBaseClassRepository.getConstraintHandler();
    }

    private class FieldContextFieldRepository
    implements FieldRepository {
        private final FieldRepository myServiceProviderFieldRepository;
        private final FieldRepository myRatingPlanFieldRepository;

        FieldContextFieldRepository(FieldRepository serviceProviderFieldRepository) {
            this.myServiceProviderFieldRepository = serviceProviderFieldRepository;
            this.myRatingPlanFieldRepository = null;
        }

        FieldContextFieldRepository(FieldRepository serviceProviderFieldRepository, FieldRepository ratingPlanFieldRepository) {
            this.myServiceProviderFieldRepository = serviceProviderFieldRepository;
            this.myRatingPlanFieldRepository = ratingPlanFieldRepository;
        }

        @Override
        public String getSeparator() {
            return RMAClassRepositoryWithContext.this.myFieldRepository.getSeparator();
        }

        @Override
        public FieldHierarchyNode getFieldByName(String name) {
            FieldHierarchyNode retField = null;
            for (FieldHierarchyNode field : this.getAllFields()) {
                if (!field.getCanonicalName().equals(name)) continue;
                retField = field;
                break;
            }
            return retField;
        }

        @Override
        public List<String> getAllFieldNames() {
            ArrayList<String> fieldNames = new ArrayList<String>();
            for (FieldHierarchyNode field : this.getAllFields()) {
                fieldNames.add(field.getCanonicalName());
            }
            Collections.sort(fieldNames);
            return fieldNames;
        }

        @Override
        public List<FieldHierarchyNode> getAllFields() {
            List<Object> fieldsToTest = new ArrayList();
            List<FieldHierarchyNode> notAllowedFields = RMAClassRepositoryWithContext.this.myFieldRepository.getAllFields();
            if (this.myServiceProviderFieldRepository != null) {
                if (this.myRatingPlanFieldRepository == null) {
                    fieldsToTest = this.myServiceProviderFieldRepository.getAllFields();
                } else {
                    notAllowedFields.addAll(this.myServiceProviderFieldRepository.getAllFields());
                    fieldsToTest = this.myRatingPlanFieldRepository.getAllFields();
                }
            } else if (this.myRatingPlanFieldRepository != null) {
                fieldsToTest = this.myRatingPlanFieldRepository.getAllFields();
            }
            ArrayList<FieldHierarchyNode> fields = new ArrayList<FieldHierarchyNode>();
            for (FieldHierarchyNode fieldHierarchyNode : fieldsToTest) {
                if (notAllowedFields.contains(fieldHierarchyNode)) continue;
                fields.add(fieldHierarchyNode);
            }
            return fields;
        }

        @Override
        public List<FieldHierarchyNode> getTopLevelFields() {
            ArrayList<FieldHierarchyNode> fields = new ArrayList<FieldHierarchyNode>();
            for (FieldHierarchyNode field : this.getAllFields()) {
                if (!this.isTopLevelField(field)) continue;
                fields.add(field);
            }
            return fields;
        }

        private boolean isTopLevelField(FieldHierarchyNode node) {
            return node != null && node.getParent() == null;
        }
    }
}

