/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.defs;

import com.ericsson.ere.datatype.ValueResolver;
import com.ericsson.ere.defs.AbstractValueType;
import com.ericsson.ere.exception.ServiceDataException;
import ericsson.ere.datatype.ContextBasedValueResolver;
import ericsson.ere.datatype.DataType;
import ericsson.ere.datatype.interfaces.ValueClassFactory;
import ericsson.ere.defs.ClassRepository;

public final class DataTypeBasedValueType
extends AbstractValueType {
    private final DataType myDataType;

    private DataTypeBasedValueType(ValueClassFactory factory, DataType dataType) {
        super(factory);
        this.myDataType = dataType;
    }

    public static DataTypeBasedValueType createValueType(DataType dataType, ClassRepository classRepository) {
        if (dataType == null) {
            throw new IllegalArgumentException("Parameter dataType cannot be null.");
        }
        if (classRepository == null) {
            throw new IllegalArgumentException("Parameter classRepository cannot be null.");
        }
        ContextBasedValueResolver contextBasedValueResolver = dataType.createContextBasedValueResolver();
        ValueResolver factory = contextBasedValueResolver.withClassRepository(classRepository).finish();
        return new DataTypeBasedValueType(factory, dataType);
    }

    public static DataTypeBasedValueType createValueType(String dataTypeString, ClassRepository classRepository) throws ServiceDataException, IllegalArgumentException {
        if (dataTypeString == null) {
            throw new IllegalArgumentException("Parameter dataTypeString cannot be null.");
        }
        if (classRepository == null) {
            throw new IllegalArgumentException("Parameter classRepository cannot be null.");
        }
        DataType dataType = DataType.lookup(dataTypeString);
        if (dataType == null) {
            throw new ServiceDataException("Could not create data type from string: " + dataTypeString);
        }
        return DataTypeBasedValueType.createValueType(dataType, classRepository);
    }

    @Override
    public DataType getDataType() {
        return this.myDataType;
    }

    @Override
    public boolean containsDataType() {
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ValueType[DataType: ").append(this.myDataType.getTypeName()).append("]");
        return sb.toString();
    }
}

