/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.defs;

import com.ericsson.ere.defs.DataRepositoryImpl;
import com.ericsson.ere.defs.DataRepositoryModel;
import com.ericsson.ere.defs.DataRepositoryModelListener;
import com.ericsson.ere.defs.ValueType;
import com.ericsson.ere.exception.ServiceDataException;
import com.ericsson.ere.util.CloneUtil;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.xml.DomWriter;
import ericsson.ere.xml.XMLUtil;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DataRepositoryModelImpl
extends DataRepositoryImpl
implements DataRepositoryModel {
    private List<DataRepositoryModelListener> myListeners = new LinkedList<DataRepositoryModelListener>();
    private boolean isModified = false;

    public DataRepositoryModelImpl(Element dataRoot, ClassRepository classRepository) throws ServiceDataException {
        super(dataRoot, classRepository);
    }

    @Override
    public void addValue(String name, ValueType valueType, Object value) throws ServiceDataException {
        this.validateValue(name, valueType, value);
        this.checkIfNameExists(name, "Name: " + name + " already exists in repository.");
        Object o = this.getImmutableOrClonedObject(value, valueType.getValueClassFactory(), CloneUtil.isKnownImmutable(value));
        this.mySingleValues.put(name, new DataRepositoryImpl.TypedValue(o, valueType));
        this.fireChangeListeners();
    }

    @Override
    public void validateValue(String name, ValueType valueType, Object value) throws ServiceDataException, IllegalArgumentException {
        this.checkForNullAndEmptyString(name, "Name");
        this.checkNameForInvalidChars(name);
        this.checkForNull(valueType, "Value type");
        this.checkForNull(value, "Value");
        this.checkIfValueTypeCanCreateValue(valueType, value);
    }

    @Override
    public void addValueArray(String name, ValueType valueType, Object[] array) throws ServiceDataException {
        this.validateValueArray(name, valueType, array);
        this.checkIfNameExists(name, "Name: " + name + " already exists in repository.");
        DataRepositoryImpl.TypedList arrayValues = new DataRepositoryImpl.TypedList(valueType);
        for (Object value : array) {
            arrayValues.add(this.getImmutableOrClonedObject(value, valueType.getValueClassFactory(), arrayValues.isImmutable()));
        }
        this.myArrayValues.put(name, arrayValues);
        this.fireChangeListeners();
    }

    @Override
    public void validateValueArray(String name, ValueType valueType, Object[] array) throws ServiceDataException {
        this.checkForNullAndEmptyString(name, "Name");
        this.checkNameForInvalidChars(name);
        this.checkForNull(valueType, "Value type");
        this.checkForNull(array, "Array");
        for (Object value : array) {
            this.checkIfValueTypeCanCreateValue(valueType, value);
        }
    }

    @Override
    public void addValueMap(String name, ValueType keyValueType, ValueType valueType, Map<? extends Object, ? extends Object> map) throws ServiceDataException {
        this.validateValueMap(name, keyValueType, valueType, map);
        this.checkIfNameExists(name, "Name: " + name + " already exists in repository.");
        DataRepositoryImpl.TypedMap mapValues = new DataRepositoryImpl.TypedMap(keyValueType, valueType);
        for (Map.Entry<? extends Object, ? extends Object> mapEntry : map.entrySet()) {
            Object key = mapEntry.getKey();
            Object value = mapEntry.getValue();
            Object keyToAdd = this.getImmutableOrClonedObject(key, keyValueType.getValueClassFactory(), mapValues.isKeyImmutable());
            Object valueToAdd = this.getImmutableOrClonedObject(value, valueType.getValueClassFactory(), mapValues.isValueImmutable());
            mapValues.put(keyToAdd, valueToAdd);
        }
        this.myMapValues.put(name, mapValues);
        this.fireChangeListeners();
    }

    @Override
    public void validateValueMap(String name, ValueType keyValueType, ValueType valueType, Map<? extends Object, ? extends Object> map) throws ServiceDataException {
        this.checkForNullAndEmptyString(name, "Name");
        this.checkNameForInvalidChars(name);
        this.checkForNull(keyValueType, "Key value type");
        this.checkForNull(valueType, "Value type");
        this.checkForNull(map, "Map");
        for (Map.Entry<? extends Object, ? extends Object> mapEntry : map.entrySet()) {
            Object key = mapEntry.getKey();
            Object value = mapEntry.getValue();
            this.checkIfValueTypeCanCreateValue(keyValueType, key);
            this.checkIfValueTypeCanCreateValue(valueType, value);
        }
    }

    @Override
    public void addXMLFragment(String name, Element xmlFragment) throws ServiceDataException {
        this.validateXMLFragment(name, xmlFragment);
        this.checkIfNameExists(name, "Name: " + name + " already exists in repository.");
        try {
            Element copy = (Element)XMLUtil.createEmptyDocument().importNode(xmlFragment, true);
            this.myXMLFragmentValues.put(name, copy);
        }
        catch (DOMException ex) {
            throw new ServiceDataException("Failed to import XML fragment", ex);
        }
        this.fireChangeListeners();
    }

    @Override
    public void validateXMLFragment(String name, Element xmlFragment) {
        this.checkForNullAndEmptyString(name, "Name");
        this.checkNameForInvalidChars(name);
        this.checkForNull(xmlFragment, "XML fragment");
    }

    @Override
    public boolean remove(String name) {
        this.checkForNullAndEmptyString(name, "Name");
        boolean returnValue = false;
        returnValue = returnValue || this.mySingleValues.remove(name) != null;
        returnValue = returnValue || this.myArrayValues.remove(name) != null;
        returnValue = returnValue || this.myMapValues.remove(name) != null;
        boolean bl = returnValue = returnValue || this.myXMLFragmentValues.remove(name) != null;
        if (returnValue) {
            this.fireChangeListeners();
        }
        return returnValue;
    }

    @Override
    public ValueType getValueType(String name) {
        this.checkForNullAndEmptyString(name, "Name");
        ValueType returnValue = null;
        if (this.mySingleValues.containsKey(name)) {
            DataRepositoryImpl.TypedValue typedValue = (DataRepositoryImpl.TypedValue)this.mySingleValues.get(name);
            returnValue = typedValue.getValueType();
        } else if (this.myArrayValues.containsKey(name)) {
            DataRepositoryImpl.TypedList typedList = (DataRepositoryImpl.TypedList)this.myArrayValues.get(name);
            returnValue = typedList.getValueType();
        } else if (this.myMapValues.containsKey(name)) {
            DataRepositoryImpl.TypedMap typedMap = (DataRepositoryImpl.TypedMap)this.myMapValues.get(name);
            returnValue = typedMap.getValueType();
        }
        return returnValue;
    }

    @Override
    public ValueType getKeyType(String name) {
        this.checkForNullAndEmptyString(name, "Name");
        ValueType returnValue = null;
        if (this.myMapValues.containsKey(name)) {
            DataRepositoryImpl.TypedMap typedMap = (DataRepositoryImpl.TypedMap)this.myMapValues.get(name);
            returnValue = typedMap.getKeyValueType();
        }
        return returnValue;
    }

    @Override
    public int size() {
        return this.mySingleValues.size() + this.myArrayValues.size() + this.myMapValues.size() + this.myXMLFragmentValues.size();
    }

    @Override
    public Element getRepositoryElement() {
        Document doc = XMLUtil.createEmptyDocument();
        Element rootElement = doc.createElement("Data");
        doc.appendChild(rootElement);
        for (Map.Entry singleValue : this.mySingleValues.entrySet()) {
            this.createAndAppendElementForSingleValue(doc, (String)singleValue.getKey(), (DataRepositoryImpl.TypedValue)singleValue.getValue());
        }
        for (Map.Entry array : this.myArrayValues.entrySet()) {
            this.createAndAppendElementForArray(doc, (String)array.getKey(), (DataRepositoryImpl.TypedList)array.getValue());
        }
        for (Map.Entry map : this.myMapValues.entrySet()) {
            this.createAndAppendElementForMap(doc, (String)map.getKey(), (DataRepositoryImpl.TypedMap)map.getValue());
        }
        for (Map.Entry xmlFragment : this.myXMLFragmentValues.entrySet()) {
            this.createAndAppendElementForXmlFragment(doc, (String)xmlFragment.getKey(), (Element)xmlFragment.getValue());
        }
        return rootElement;
    }

    @Override
    public boolean exists(String name) {
        if (name == null) {
            return false;
        }
        return this.mySingleValues.containsKey(name) || this.myArrayValues.containsKey(name) || this.myMapValues.containsKey(name) || this.myXMLFragmentValues.containsKey(name);
    }

    @Override
    public Set<Map.Entry<String, DataRepositoryModel.RepositoryDataType>> keyEntrySet() {
        Set<String> singleValueKeys = this.mySingleValues.keySet();
        Set<String> arrayValueKeys = this.myArrayValues.keySet();
        Set<String> mapValueKeys = this.myMapValues.keySet();
        Set<String> xmlFragmentKeys = this.myXMLFragmentValues.keySet();
        LinkedHashMap<String, DataRepositoryModel.RepositoryDataType> keysMap = new LinkedHashMap<String, DataRepositoryModel.RepositoryDataType>();
        this.addKeysAndTypeToMap(keysMap, singleValueKeys, DataRepositoryModel.RepositoryDataType.SINGLE_VALUE);
        this.addKeysAndTypeToMap(keysMap, arrayValueKeys, DataRepositoryModel.RepositoryDataType.ARRAY);
        this.addKeysAndTypeToMap(keysMap, mapValueKeys, DataRepositoryModel.RepositoryDataType.MAP);
        this.addKeysAndTypeToMap(keysMap, xmlFragmentKeys, DataRepositoryModel.RepositoryDataType.XML_FRAGMENT);
        return keysMap.entrySet();
    }

    private void createAndAppendElementForSingleValue(Document doc, String name, DataRepositoryImpl.TypedValue value) {
        Element element = doc.createElement("SingleValue");
        doc.getDocumentElement().appendChild(element);
        element.setAttribute("name", name);
        ValueType valueType = value.getValueType();
        if (valueType.containsDataType()) {
            element.setAttribute("dataType", valueType.getDataType().getTypeName());
        } else {
            element.setAttribute("valueClassFactory", valueType.getValueClassFactory().getClass().getName());
            element.setAttribute("valueClass", valueType.getValueClass().getName());
        }
        String valueString = valueType.getValueClassFactory().makeValueString(value.getValue());
        element.appendChild(doc.createTextNode(valueString));
    }

    private void createAndAppendElementForArray(Document doc, String name, DataRepositoryImpl.TypedList valueList) {
        Element arrayElement = doc.createElement("Array");
        doc.getDocumentElement().appendChild(arrayElement);
        arrayElement.setAttribute("name", name);
        ValueType valueType = valueList.getValueType();
        if (valueType.containsDataType()) {
            arrayElement.setAttribute("dataType", valueType.getDataType().getTypeName());
        } else {
            arrayElement.setAttribute("valueClassFactory", valueType.getValueClassFactory().getClass().getName());
            arrayElement.setAttribute("valueClass", valueType.getValueClass().getName());
        }
        for (Object value : valueList) {
            String valueString = valueType.getValueClassFactory().makeValueString(value);
            Element valueElement = doc.createElement("Value");
            valueElement.appendChild(doc.createTextNode(valueString));
            arrayElement.appendChild(valueElement);
        }
    }

    private void createAndAppendElementForMap(Document doc, String name, DataRepositoryImpl.TypedMap valueMap) {
        Element arrayElement = doc.createElement("Map");
        doc.getDocumentElement().appendChild(arrayElement);
        arrayElement.setAttribute("name", name);
        ValueType keyValueType = valueMap.getKeyValueType();
        if (keyValueType.containsDataType()) {
            arrayElement.setAttribute("keyDataType", keyValueType.getDataType().getTypeName());
        } else {
            arrayElement.setAttribute("keyClassFactory", keyValueType.getValueClassFactory().getClass().getName());
            arrayElement.setAttribute("keyClass", keyValueType.getValueClass().getName());
        }
        ValueType valueType = valueMap.getValueType();
        if (valueType.containsDataType()) {
            arrayElement.setAttribute("valueDataType", valueType.getDataType().getTypeName());
        } else {
            arrayElement.setAttribute("valueClassFactory", valueType.getValueClassFactory().getClass().getName());
            arrayElement.setAttribute("valueClass", valueType.getValueClass().getName());
        }
        for (Map.Entry mapEntry : valueMap.entrySet()) {
            String valueString = valueType.getValueClassFactory().makeValueString(mapEntry.getValue());
            Element valueElement = doc.createElement("Value");
            valueElement.setAttribute("key", keyValueType.getValueClassFactory().makeValueString(mapEntry.getKey()));
            valueElement.appendChild(doc.createTextNode(valueString));
            arrayElement.appendChild(valueElement);
        }
    }

    private void createAndAppendElementForXmlFragment(Document doc, String name, Element element) {
        Element xmlElement = doc.createElement("XMLFragment");
        doc.getDocumentElement().appendChild(xmlElement);
        xmlElement.setAttribute("name", name);
        Element elementCopy = (Element)doc.importNode(element, true);
        xmlElement.appendChild(elementCopy);
    }

    private void checkIfValueTypeCanCreateValue(ValueType valueType, Object value) throws ServiceDataException {
        if (!valueType.isInstance(value)) {
            throw new ServiceDataException("Data type mismatch. Value type class: " + valueType + ", is not assignable from class type: " + value.getClass().getName());
        }
    }

    private void addKeysAndTypeToMap(Map<String, DataRepositoryModel.RepositoryDataType> keyDataTypeMap, Set<String> keySet, DataRepositoryModel.RepositoryDataType dataType) {
        for (String key : keySet) {
            keyDataTypeMap.put(key, dataType);
        }
    }

    private void checkNameForInvalidChars(String name) throws IllegalArgumentException {
        if (name.matches(".*[<>].*")) {
            throw new IllegalArgumentException("Parameter Name cannot contain characters \"<\" or \">\".");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SingleValues:\n");
        for (Map.Entry e : this.mySingleValues.entrySet()) {
            this.addRowToStringBuilder(sb, (String)e.getKey(), ((DataRepositoryImpl.TypedValue)e.getValue()).getValue().toString());
        }
        sb.append("Arrays:\n");
        for (Map.Entry e : this.myArrayValues.entrySet()) {
            this.addRowToStringBuilder(sb, (String)e.getKey(), ((DataRepositoryImpl.TypedList)e.getValue()).toString());
        }
        sb.append("Maps:\n");
        for (Map.Entry e : this.myMapValues.entrySet()) {
            this.addRowToStringBuilder(sb, (String)e.getKey(), ((DataRepositoryImpl.TypedMap)e.getValue()).toString());
        }
        sb.append("XMLFragments:\n");
        for (Map.Entry e : this.myXMLFragmentValues.entrySet()) {
            this.addRowToStringBuilder(sb, (String)e.getKey(), DomWriter.nodeToString((Node)e.getValue(), false));
        }
        return sb.toString();
    }

    private void addRowToStringBuilder(StringBuilder sb, String name, String value) {
        sb.append("  ");
        sb.append(name);
        sb.append("=");
        sb.append(value);
        sb.append("\n");
    }

    private void fireChangeListeners() {
        this.isModified = true;
        for (DataRepositoryModelListener listener : this.myListeners) {
            listener.repositoryUpdated();
        }
    }

    @Override
    public void addDataRepositoryListener(DataRepositoryModelListener listener) {
        this.checkForNull(listener, "DataRepositoryListener");
        this.myListeners.add(listener);
    }

    @Override
    public void removeDataRepositoryListener(DataRepositoryModelListener listener) {
        this.checkForNull(listener, "DataRepositoryListener");
        this.myListeners.remove(listener);
    }

    @Override
    public boolean isModified() {
        return this.isModified;
    }

    @Override
    public void resetModified() {
        this.isModified = false;
    }
}

