/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.defs;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.Key;
import com.ericsson.ere.defs.AbstractValueType;
import com.ericsson.ere.defs.DataRepository;
import com.ericsson.ere.defs.DataTypeBasedValueType;
import com.ericsson.ere.defs.ValueClassBasedValueType;
import com.ericsson.ere.defs.ValueType;
import com.ericsson.ere.exception.ServiceDataException;
import com.ericsson.ere.util.CloneUtil;
import ericsson.ere.datatype.interfaces.ValueClassFactory;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.util.StringUtil;
import ericsson.ere.xml.XMLUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@Immutable
public class DataRepositoryImpl
implements DataRepository {
    protected static final String TAG_SINGLE_VALUE = "SingleValue";
    protected static final String TAG_ARRAY = "Array";
    protected static final String TAG_VALUE = "Value";
    protected static final String TAG_MAP = "Map";
    protected static final String TAG_XML_FRAGMENT = "XMLFragment";
    protected static final String ATTRIBUTE_KEY = "key";
    protected static final String ATTRIBUTE_NAME = "name";
    protected static final String ATTRIBUTE_DATA_TYPE = "dataType";
    protected static final String ATTRIBUTE_KEY_DATA_TYPE = "keyDataType";
    protected static final String ATTRIBUTE_KEY_CLASS_FACTORY = "keyClassFactory";
    protected static final String ATTRIBUTE_KEY_CLASS = "keyClass";
    protected static final String ATTRIBUTE_VALUE_DATA_TYPE = "valueDataType";
    protected static final String ATTRIBUTE_VALUE_CLASS_FACTORY = "valueClassFactory";
    protected static final String ATTRIBUTE_VALUE_CLASS = "valueClass";
    final Map<String, TypedValue> mySingleValues = new LinkedHashMap<String, TypedValue>();
    final Map<String, TypedList> myArrayValues = new LinkedHashMap<String, TypedList>();
    final Map<String, TypedMap> myMapValues = new LinkedHashMap<String, TypedMap>();
    final Map<String, Element> myXMLFragmentValues = new LinkedHashMap<String, Element>();
    private final ClassRepository myClassRepository;

    public DataRepositoryImpl(Element dataRoot, ClassRepository classRepository) throws ServiceDataException {
        this.checkForNull(classRepository, "Class Repository");
        this.myClassRepository = classRepository;
        if (dataRoot != null) {
            this.validateXmlSchema(dataRoot);
            this.initSingleValueData(dataRoot);
            this.initArrayData(dataRoot);
            this.initMapData(dataRoot);
            this.initXMLFragmentData(dataRoot);
        }
    }

    @Override
    public Object getValue(String name) throws ServiceDataException {
        this.checkForNullAndEmptyString(name, ATTRIBUTE_NAME);
        TypedValue typedValue = this.mySingleValues.get(name);
        Object returnValue = null;
        if (typedValue == null) {
            this.checkIfNameExists(name, "Data type mismatch, \"" + name + "\" is not a single value");
        } else {
            returnValue = this.getImmutableOrClonedSingleValue(typedValue);
        }
        return returnValue;
    }

    @Override
    public Object getValue(String name, Key key) throws ServiceDataException {
        this.checkForNullAndEmptyString(name, ATTRIBUTE_NAME);
        this.checkForNull(key, ATTRIBUTE_KEY);
        Object returnValue = null;
        returnValue = key.containsIndex() ? this.getValueFromArray(name, key) : this.getValueFromMap(name, key);
        return returnValue;
    }

    private Object getValueFromArray(String name, Key key) {
        Object returnValue = null;
        TypedList list = this.myArrayValues.get(name);
        if (list == null) {
            this.checkIfNameExists(name, "Data type mismatch, \"" + name + "\" is not an array");
        } else {
            int index = key.getIndex();
            if (index < list.size()) {
                returnValue = this.getImmutableOrClonedObject(list.get(index), list.getValueType().getValueClassFactory(), list.isImmutable());
            }
        }
        return returnValue;
    }

    private Object getValueFromMap(String name, Key key) {
        Object returnValue = null;
        TypedMap map = this.myMapValues.get(name);
        if (map == null) {
            this.checkIfNameExists(name, "Data type mismatch, \"" + name + "\" is not a map");
        } else {
            if (map.getKeyType() != key.getKey().getClass()) {
                throw new ServiceDataException("Data type mismatch in map key.");
            }
            returnValue = this.getImmutableOrClonedObject(map.get(key.getKey()), map.getValueType().getValueClassFactory(), map.isValueImmutable());
        }
        return returnValue;
    }

    @Override
    public Object[] getValueArray(String name) throws ServiceDataException {
        this.checkForNullAndEmptyString(name, ATTRIBUTE_NAME);
        TypedList list = this.myArrayValues.get(name);
        Object[] returnValue = null;
        if (list == null) {
            this.checkIfNameExists(name, "Data type mismatch, \"" + name + "\" is not an array");
        } else {
            returnValue = this.getImmutableOrClonedArray(list);
        }
        return returnValue;
    }

    @Override
    public Map<Object, Object> getValueMap(String name) throws ServiceDataException {
        this.checkForNullAndEmptyString(name, ATTRIBUTE_NAME);
        TypedMap map = this.myMapValues.get(name);
        Map<Object, Object> returnValue = null;
        if (map == null) {
            this.checkIfNameExists(name, "Data type mismatch, \"" + name + "\" is not a map");
        } else {
            returnValue = Collections.unmodifiableMap(this.getImmutableOrClonedMap(map));
        }
        return returnValue;
    }

    @Override
    public Element getXMLFragment(String name) throws ServiceDataException {
        this.checkForNullAndEmptyString(name, ATTRIBUTE_NAME);
        Element element = this.myXMLFragmentValues.get(name);
        Element returnValue = null;
        if (element == null) {
            this.checkIfNameExists(name, "Data type mismatch, \"" + name + "\" is not a XML fragment");
        } else {
            returnValue = XMLUtil.cloneElement(element);
        }
        return returnValue;
    }

    private void initSingleValueData(Element myDataRoot) throws ServiceDataException {
        List<Element> singleValueElements = XMLUtil.getElementNodesNamed(TAG_SINGLE_VALUE, myDataRoot.getChildNodes());
        for (Element e : singleValueElements) {
            String name = e.getAttribute(ATTRIBUTE_NAME);
            String dataTypeString = e.getAttribute(ATTRIBUTE_DATA_TYPE);
            String valueClassFactoryString = e.getAttribute(ATTRIBUTE_VALUE_CLASS_FACTORY);
            String valueClassString = e.getAttribute(ATTRIBUTE_VALUE_CLASS);
            String valueString = e.getTextContent();
            this.checkIfNameExists(name, "Data name not unique: " + name);
            this.checkIfAttributesAreMutuallyExclusive(dataTypeString, valueClassFactoryString, valueClassString, ATTRIBUTE_DATA_TYPE, ATTRIBUTE_VALUE_CLASS_FACTORY, ATTRIBUTE_VALUE_CLASS);
            ValueType valueType = this.createValueType(dataTypeString, valueClassFactoryString, valueClassString);
            Object value = valueType.createObjectFromString(valueString);
            this.mySingleValues.put(name, new TypedValue(value, valueType));
        }
    }

    private void initArrayData(Element myDataRoot) throws ServiceDataException {
        List<Element> arrayValueElements = XMLUtil.getElementNodesNamed(TAG_ARRAY, myDataRoot.getChildNodes());
        for (Element arrayElement : arrayValueElements) {
            String name = arrayElement.getAttribute(ATTRIBUTE_NAME);
            String dataTypeString = arrayElement.getAttribute(ATTRIBUTE_DATA_TYPE);
            String valueClassFactoryString = arrayElement.getAttribute(ATTRIBUTE_VALUE_CLASS_FACTORY);
            String valueClassString = arrayElement.getAttribute(ATTRIBUTE_VALUE_CLASS);
            this.checkIfNameExists(name, "Data name not unique: " + name);
            this.checkIfAttributesAreMutuallyExclusive(dataTypeString, valueClassFactoryString, valueClassString, ATTRIBUTE_DATA_TYPE, ATTRIBUTE_VALUE_CLASS_FACTORY, ATTRIBUTE_VALUE_CLASS);
            ValueType valueType = this.createValueType(dataTypeString, valueClassFactoryString, valueClassString);
            TypedList array = new TypedList(valueType);
            List<Element> valueElements = XMLUtil.getElementNodesNamed(TAG_VALUE, arrayElement.getChildNodes());
            for (Element valueElement : valueElements) {
                String valueString = valueElement.getTextContent();
                Object value = valueType.createObjectFromString(valueString);
                array.add(value);
            }
            this.myArrayValues.put(name, array);
        }
    }

    private void initMapData(Element myDataRoot) throws ServiceDataException {
        List<Element> mapValueElements = XMLUtil.getElementNodesNamed(TAG_MAP, myDataRoot.getChildNodes());
        for (Element mapElement : mapValueElements) {
            String name = mapElement.getAttribute(ATTRIBUTE_NAME);
            String keyDataTypeString = mapElement.getAttribute(ATTRIBUTE_KEY_DATA_TYPE);
            String keyClassFactoryString = mapElement.getAttribute(ATTRIBUTE_KEY_CLASS_FACTORY);
            String keyClassString = mapElement.getAttribute(ATTRIBUTE_KEY_CLASS);
            String valueDataTypeString = mapElement.getAttribute(ATTRIBUTE_VALUE_DATA_TYPE);
            String valueClassFactoryString = mapElement.getAttribute(ATTRIBUTE_VALUE_CLASS_FACTORY);
            String valueClassString = mapElement.getAttribute(ATTRIBUTE_VALUE_CLASS);
            this.checkIfNameExists(name, "Data name not unique: " + name);
            this.checkIfAttributesAreMutuallyExclusive(keyDataTypeString, keyClassFactoryString, keyClassString, ATTRIBUTE_KEY_DATA_TYPE, ATTRIBUTE_KEY_CLASS_FACTORY, ATTRIBUTE_KEY_CLASS);
            this.checkIfAttributesAreMutuallyExclusive(valueDataTypeString, valueClassFactoryString, valueClassString, ATTRIBUTE_VALUE_DATA_TYPE, ATTRIBUTE_VALUE_CLASS_FACTORY, ATTRIBUTE_VALUE_CLASS);
            ValueType keyValueType = this.createValueType(keyDataTypeString, keyClassFactoryString, keyClassString);
            ValueType valueType = this.createValueType(valueDataTypeString, valueClassFactoryString, valueClassString);
            TypedMap map = new TypedMap(keyValueType, valueType);
            List<Element> valueElements = XMLUtil.getElementNodesNamed(TAG_VALUE, mapElement.getChildNodes());
            for (Element valueElement : valueElements) {
                String keyValueString = valueElement.getAttribute(ATTRIBUTE_KEY);
                Object key = keyValueType.createObjectFromString(keyValueString);
                if (map.containsKey(key)) {
                    throw new ServiceDataException("Service Data invalid. Key: " + key + " already exists in map: " + name);
                }
                String valueString = valueElement.getTextContent();
                Object value = valueType.createObjectFromString(valueString);
                map.put(key, value);
            }
            this.myMapValues.put(name, map);
        }
    }

    private void initXMLFragmentData(Element myDataRoot) throws ServiceDataException {
        List<Element> xmlFragmentElements = XMLUtil.getElementNodesNamed(TAG_XML_FRAGMENT, myDataRoot.getChildNodes());
        for (Element e : xmlFragmentElements) {
            Node child;
            String name = e.getAttribute(ATTRIBUTE_NAME);
            this.checkIfNameExists(name, "Data name not unique: " + name);
            e.getParentNode().removeChild(e);
            for (child = e.getFirstChild(); child != null && child.getNodeType() != 1; child = child.getNextSibling()) {
            }
            Element element = (Element)child;
            this.myXMLFragmentValues.put(name, XMLUtil.cloneElement(element));
        }
    }

    private void validateXmlSchema(Node node) throws ServiceDataException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Class<?> class1 = this.getClass();
        InputStream resourceAsStream = class1.getResourceAsStream("/config/ere-service-data-schema.xsd");
        StreamSource streamSource = new StreamSource(resourceAsStream);
        try {
            Schema schema = factory.newSchema(streamSource);
            Validator validator = schema.newValidator();
            validator.validate(new DOMSource(node));
        }
        catch (SAXException ex) {
            throw new ServiceDataException("Service Data schema validation failed.", ex);
        }
        catch (IOException ex) {
            throw new ServiceDataException("Service Data schema validation failed.", ex);
        }
    }

    void checkForNull(Object name, String parameterName) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter " + parameterName + " cannot be null.");
        }
    }

    void checkForNullAndEmptyString(String name, String parameterName) {
        this.checkForNull(name, parameterName);
        if (StringUtil.isEmptyString(name)) {
            throw new IllegalArgumentException("Parameter " + parameterName + " cannot be empty.");
        }
    }

    void checkIfNameExists(String name, String exceptionString) throws ServiceDataException {
        if (this.mySingleValues.containsKey(name) || this.myArrayValues.containsKey(name) || this.myMapValues.containsKey(name) || this.myXMLFragmentValues.containsKey(name)) {
            throw new ServiceDataException(exceptionString);
        }
    }

    private void checkIfAttributesAreMutuallyExclusive(String dataTypeString, String valueClassFactoryString, String valueClassString, String dataTypeAttributeName, String valueClassFactoryAttributeName, String valueClassAttributeName) throws ServiceDataException {
        boolean onlyVCFandVCGiven;
        boolean dataTypeStringGiven = !StringUtil.isEmptyString(dataTypeString);
        boolean valueClassFactoryStringGiven = !StringUtil.isEmptyString(valueClassFactoryString);
        boolean valueClassStringGiven = !StringUtil.isEmptyString(valueClassString);
        boolean onlyDataTypeGiven = dataTypeStringGiven && !valueClassFactoryStringGiven && !valueClassStringGiven;
        boolean bl = onlyVCFandVCGiven = !dataTypeStringGiven && valueClassFactoryStringGiven && valueClassStringGiven;
        if (!onlyDataTypeGiven && !onlyVCFandVCGiven) {
            throw new ServiceDataException("Attributes " + dataTypeAttributeName + " and " + valueClassFactoryAttributeName + "+" + valueClassAttributeName + " are mutually exclusive.");
        }
    }

    private ValueType createValueType(String dataTypeString, String valueClassFactoryString, String valueClassString) throws ServiceDataException {
        AbstractValueType valueType = StringUtil.isEmptyString(dataTypeString) ? ValueClassBasedValueType.createValueType(valueClassFactoryString, valueClassString, this.myClassRepository) : DataTypeBasedValueType.createValueType(dataTypeString, this.myClassRepository);
        return valueType;
    }

    Object getImmutableOrClonedObject(Object value, ValueClassFactory valueClassFactory, boolean isImmutable) {
        return isImmutable ? value : valueClassFactory.parseValueString(valueClassFactory.makeValueString(value));
    }

    private Object getImmutableOrClonedSingleValue(TypedValue typedValue) {
        return this.getImmutableOrClonedObject(typedValue.getValue(), typedValue.getValueType().getValueClassFactory(), typedValue.isImmutable());
    }

    private Object[] getImmutableOrClonedArray(TypedList list) {
        Object[] array = new Object[list.size()];
        int i = 0;
        for (Object value : list) {
            array[i++] = this.getImmutableOrClonedObject(value, list.getValueType().getValueClassFactory(), list.isImmutable());
        }
        return array;
    }

    private Map<? extends Object, ? extends Object> getImmutableOrClonedMap(TypedMap map) {
        LinkedHashMap returnMap = map;
        if (!map.isKeyImmutable() || !map.isValueImmutable()) {
            LinkedHashMap<Object, Object> copy = new LinkedHashMap<Object, Object>();
            for (Map.Entry e : map.entrySet()) {
                Object key = this.getImmutableOrClonedObject(e.getKey(), map.getKeyValueType().getValueClassFactory(), map.isKeyImmutable());
                Object value = this.getImmutableOrClonedObject(e.getValue(), map.getValueType().getValueClassFactory(), map.isValueImmutable());
                copy.put(key, value);
            }
            returnMap = copy;
        }
        return returnMap;
    }

    static class TypedValue {
        private final Object myValue;
        private final ValueType myValueType;
        private final boolean myIsImmutable;

        public TypedValue(Object value, ValueType valueType) {
            this.myValue = value;
            this.myValueType = valueType;
            this.myIsImmutable = CloneUtil.isKnownImmutable(value);
        }

        public boolean isImmutable() {
            return this.myIsImmutable;
        }

        public ValueType getValueType() {
            return this.myValueType;
        }

        public Object getValue() {
            return this.myValue;
        }
    }

    static class TypedList
    extends ArrayList<Object> {
        private final ValueType myValueType;
        private final boolean myIsImmutable;

        public TypedList(ValueType valueType) {
            this.myValueType = valueType;
            this.myIsImmutable = CloneUtil.isKnownImmutable(valueType.getValueClassFactory().createDefaultInstance());
        }

        public ValueType getValueType() {
            return this.myValueType;
        }

        public boolean isImmutable() {
            return this.myIsImmutable;
        }
    }

    static class TypedMap
    extends LinkedHashMap<Object, Object> {
        private final Class<?> myKeyType;
        private final ValueType myKeyValueType;
        private final boolean myIsKeyImmutable;
        private final ValueType myValueType;
        private final boolean myIsValueImmutable;

        public TypedMap(ValueType keyValueType, ValueType valueType) {
            this.myKeyValueType = keyValueType;
            this.myValueType = valueType;
            Object keyDefaultInstance = keyValueType.getValueClassFactory().createDefaultInstance();
            this.myIsKeyImmutable = CloneUtil.isKnownImmutable(keyDefaultInstance);
            this.myIsValueImmutable = CloneUtil.isKnownImmutable(valueType.getValueClassFactory().createDefaultInstance());
            this.myKeyType = keyDefaultInstance.getClass();
        }

        public Class<?> getKeyType() {
            return this.myKeyType;
        }

        public ValueType getKeyValueType() {
            return this.myKeyValueType;
        }

        public boolean isKeyImmutable() {
            return this.myIsKeyImmutable;
        }

        public ValueType getValueType() {
            return this.myValueType;
        }

        public boolean isValueImmutable() {
            return this.myIsValueImmutable;
        }
    }
}

