/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.datatype;

import com.ericsson.calendar.CalendarDate;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.Key;
import com.ericsson.ere.datatype.EREDate;
import com.ericsson.ere.datatype.ERETime;
import com.ericsson.ere.datatype.ERETimeFactory;
import ericsson.ere.datatype.DataType;
import ericsson.ere.datatype.Time;
import ericsson.ere.defs.FieldDefinition;
import java.util.Calendar;
import java.util.Date;

public class ERETimeUtil {
    public static final String END_OF_TIME_TAG = "EndOfTimeLabel";
    public static final String BEGINNING_OF_TIME_TAG = "BeginningOfTimeLabel";

    private ERETimeUtil() {
    }

    public static ERETime convertToERETime(Object aValue) {
        ERETime time = null;
        if (aValue instanceof ERETime) {
            time = (ERETime)aValue;
        } else if (aValue instanceof EREDate) {
            time = ERETimeFactory.createFromDate(((EREDate)aValue).asDate());
        } else if (aValue instanceof Date) {
            time = ERETimeFactory.createFromDate((Date)aValue);
        } else if (aValue instanceof Calendar) {
            time = ERETimeFactory.createFromCalendar((Calendar)aValue);
        } else if (aValue instanceof CalendarDate) {
            CalendarDate cd = (CalendarDate)aValue;
            time = ERETimeFactory.createFrom(cd.getYear(), cd.getMonth(), cd.getDayOfMonth(), 0, 0, 0, 0);
        } else if (aValue instanceof Time) {
            time = ERETimeFactory.createFromTime((Time)aValue);
        } else if (aValue != null) {
            throw new IllegalArgumentException("Unrecognized value class: " + aValue.getClass());
        }
        return time;
    }

    public static ERETime getDataAsERETime(DataSet aDs, Object aName, Key aKey) {
        return aKey == null ? aDs.getDataAsERETime(aName) : ERETimeUtil.convertToERETime(aDs.getDataAsTypedObjectForKey(aName, aKey, DataType.TIME));
    }

    public static ERETime getDataAsERETime(DataSet aDs, int aTag, Key aKey) {
        return aKey == null ? aDs.getDataAsERETime(aTag) : ERETimeUtil.convertToERETime(aDs.getDataAsTypedObjectForKey(aTag, aKey, DataType.TIME));
    }

    public static boolean isBoundaryDate(Object anObj) {
        return anObj == ERETime.BEGINNING_OF_TIME || anObj == ERETime.END_OF_TIME;
    }

    public static boolean isBoundaryDateDefaultLabel(String aLabel) {
        return ERETime.BEGINNING_OF_TIME.toString().equals(aLabel) || ERETime.END_OF_TIME.toString().equals(aLabel);
    }

    public static String getDisplayableStringForBoundaryDateValue(Object aValue, FieldDefinition anFd) {
        String result = "";
        if (anFd != null) {
            if (ERETime.BEGINNING_OF_TIME == aValue || ERETime.BEGINNING_OF_TIME.toString().equals(aValue)) {
                result = anFd.getFieldSettings().get(BEGINNING_OF_TIME_TAG);
            } else if (ERETime.END_OF_TIME == aValue || ERETime.END_OF_TIME.toString().equals(aValue)) {
                result = anFd.getFieldSettings().get(END_OF_TIME_TAG);
            }
        }
        return result == null ? "" : result;
    }

    public static String getDisplayableStringForERETimeConstant(ERETime aTimeConstant, FieldDefinition anFd) {
        String result = "";
        if (anFd != null && ERETimeUtil.isBoundaryDate(aTimeConstant)) {
            result = ERETimeUtil.getERETimeConstantLabel(aTimeConstant, anFd);
        }
        return result == null ? "" : result;
    }

    private static String getERETimeConstantLabel(ERETime aConstant, FieldDefinition anFd) {
        String tag;
        if (ERETime.BEGINNING_OF_TIME == aConstant) {
            tag = BEGINNING_OF_TIME_TAG;
        } else if (ERETime.END_OF_TIME == aConstant) {
            tag = END_OF_TIME_TAG;
        } else {
            throw new IllegalArgumentException("Unsupported ERETime constant: " + aConstant);
        }
        String result = anFd.getFieldSettings().get(tag);
        return result == null ? aConstant.toString() : result;
    }

    public static String makeISOStringFromERETime(ERETime time) {
        if (time == null || ERETimeUtil.isBoundaryDate(time)) {
            throw new IllegalArgumentException("Argument must not be null or boundary date.");
        }
        return String.format("%04d%02d%02dT%02d%02d%02d%03d", time.getFullYear(), time.getMonthOfYear(), time.getDayOfMonth(), time.getHours(), time.getMinutes(), time.getSeconds(), time.getMilliseconds());
    }
}

