/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.datatype;

import com.ericsson.ere.datatype.DefaultERETime;
import com.ericsson.ere.datatype.EREDate;
import com.ericsson.ere.datatype.ERETime;
import ericsson.ere.datatype.Time;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class ERETimeFactory {
    private static Pattern TIME_PATTERN = Pattern.compile("(\\d{4})-?(\\d{2})-?(\\d{2})([T\\s]?(\\d{2}):?(\\d{2}):?(\\d{2})\\s?(\\d{3})?)?");
    private static ERETimeFactory myFactory = new DefaultERETimeFactory();

    protected abstract ERETime _now();

    protected abstract ERETime _createFrom(int var1, int var2, int var3, int var4, int var5, int var6, int var7);

    protected abstract ERETime _createFromMillisecondsSinceEpoch(long var1);

    protected ERETime _createFromTime(Time aTime) {
        return this._createFromCalendar(aTime.getCalendar());
    }

    protected ERETime _createFromCalendar(Calendar cal) {
        return this._createFromMillisecondsSinceEpoch(cal.getTimeInMillis());
    }

    protected ERETime _createFromDate(Date date) {
        return this._createFromMillisecondsSinceEpoch(date.getTime());
    }

    protected ERETime _copyIfNecessary(ERETime time) {
        return this._createFromMillisecondsSinceEpoch(time.getMillisecondsSinceEpoch());
    }

    public static ERETime now() {
        return myFactory._now();
    }

    public static ERETime createFrom(int aYear, int aMonth, int aDay, int anHour, int aMinute, int aSecond, int aMillisecond) {
        return myFactory._createFrom(aYear, aMonth, aDay, anHour, aMinute, aSecond, aMillisecond);
    }

    public static ERETime createFromCalendar(Calendar cal) {
        return myFactory._createFromCalendar(cal);
    }

    public static ERETime createFromDate(Date date) {
        return myFactory._createFromDate(date);
    }

    public static ERETime createFromTime(Time aTime) {
        return myFactory._createFromTime(aTime);
    }

    public static ERETime copyIfNecessary(ERETime time) {
        return myFactory._copyIfNecessary(time);
    }

    public static ERETime createFromMillisecondsSinceEpoch(long millis) {
        return myFactory._createFromMillisecondsSinceEpoch(millis);
    }

    public static ERETime parseTimeString(String timeString) {
        ERETime generatedTime;
        String notNullString = timeString == null ? "" : timeString;
        Matcher matcher = TIME_PATTERN.matcher(notNullString);
        if (matcher.matches()) {
            int year = Integer.parseInt(matcher.group(1));
            int month = Integer.parseInt(matcher.group(2));
            int day = Integer.parseInt(matcher.group(3));
            int hour = 0;
            int minute = 0;
            int second = 0;
            int millisecond = 0;
            if (matcher.group(4) != null) {
                hour = Integer.parseInt(matcher.group(5));
                minute = Integer.parseInt(matcher.group(6));
                second = Integer.parseInt(matcher.group(7));
                millisecond = 0;
                if (matcher.group(8) != null) {
                    millisecond = Integer.parseInt(matcher.group(8));
                }
            }
            generatedTime = ERETimeFactory.createFrom(year, month, day, hour, minute, second, millisecond);
        } else if (EREDate.BEGINNING_OF_TIME.toString().equals(notNullString)) {
            generatedTime = (ERETime)EREDate.BEGINNING_OF_TIME;
        } else if (ERETime.END_OF_TIME.toString().equals(notNullString)) {
            generatedTime = (ERETime)EREDate.END_OF_TIME;
        } else if ("".equals(notNullString)) {
            generatedTime = ERETimeFactory.now();
        } else {
            throw new IllegalArgumentException("Unparseable time string, must be yyyy-MM-dd, yyyyMMdd, yyyy-MM-dd HH:mm:ss SSS, yyyyMMddHHmmssSSS, yyyyMMdd'T'HHmmssSSS, or a boundary date constant: " + notNullString);
        }
        return generatedTime;
    }

    public static synchronized void install(ERETimeFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Factory must be non-null.");
        }
        myFactory = factory;
    }

    public static synchronized ERETimeFactory getCurrentTimeFactory() {
        return myFactory;
    }

    public static class DefaultERETimeFactory
    extends ERETimeFactory {
        @Override
        protected ERETime _now() {
            return this._createFromMillisecondsSinceEpoch(System.currentTimeMillis());
        }

        @Override
        protected ERETime _createFrom(int aYear, int aMonth, int aDay, int anHour, int aMinute, int aSecond, int aMillisecond) {
            return DefaultERETime.forTime(aYear, aMonth, aDay, anHour, aMinute, aSecond, aMillisecond);
        }

        @Override
        protected ERETime _createFromMillisecondsSinceEpoch(long aMilliseconds) {
            return DefaultERETime.forMillisecondsSinceEpoch(aMilliseconds);
        }
    }
}

