/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.datatype;

import com.ericsson.ere.datatype.DefaultEREDate;
import com.ericsson.ere.datatype.EREDate;
import com.ericsson.ere.datatype.ERETime;
import com.ericsson.ere.datatype.ERETimeUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class DefaultERETime
extends DefaultEREDate
implements ERETime {
    private static final long serialVersionUID = 3756885661056191053L;

    private DefaultERETime(long millis) {
        super(millis - millis % 1000L);
    }

    public static DefaultERETime forTime(int aYear, int aMonth, int aDay, int anHour, int aMinute, int aSecond, int aMillisecond) {
        GregorianCalendar cal = new GregorianCalendar(aYear, aMonth - 1, aDay, anHour, aMinute, aSecond);
        return DefaultERETime.forMillisecondsSinceEpoch(cal.getTimeInMillis());
    }

    public static DefaultERETime forMillisecondsSinceEpoch(long aMillis) {
        return new DefaultERETime(aMillis);
    }

    @Override
    public EREDate plusYears(int years) {
        DefaultERETime retVal = this;
        if (years != 0) {
            Calendar cal = this.asCalendar();
            cal.add(1, years);
            retVal = new DefaultERETime(cal.getTimeInMillis());
        }
        return retVal;
    }

    @Override
    public EREDate plusMonths(int months) {
        DefaultERETime retVal = this;
        if (months != 0) {
            Calendar cal = this.asCalendar();
            cal.add(2, months);
            retVal = new DefaultERETime(cal.getTimeInMillis());
        }
        return retVal;
    }

    @Override
    public EREDate plusDays(int days) {
        DefaultERETime retVal = this;
        if (days != 0) {
            Calendar cal = this.asCalendar();
            cal.add(5, days);
            retVal = new DefaultERETime(cal.getTimeInMillis());
        }
        return retVal;
    }

    @Override
    public ERETime plusHours(int hours) {
        return hours == 0 ? this : new DefaultERETime(this.getTime() + (long)(hours * 1000 * 60) * 60L);
    }

    @Override
    public ERETime plusMinutes(int minutes) {
        return minutes == 0 ? this : new DefaultERETime(this.getTime() + (long)(minutes * 1000) * 60L);
    }

    @Override
    public ERETime plusSeconds(int seconds) {
        return seconds == 0 ? this : new DefaultERETime(this.getTime() + (long)seconds * 1000L);
    }

    @Override
    public ERETime plusMilliseconds(int milliseconds) {
        throw new UnsupportedOperationException("DefaultERETime does not support millisecond precision.");
    }

    @Override
    public long getMillisecondsSinceEpoch() {
        return this.getTime();
    }

    @Override
    public int getMilliseconds() {
        return (int)(this.getTime() % 1000L);
    }

    @Override
    public int compareTo(ERETime other) {
        int diff = 0;
        diff = other == this ? 0 : (other == ERETime.BEGINNING_OF_TIME ? 1 : (other == ERETime.END_OF_TIME ? -1 : this.compareTime(other)));
        return diff;
    }

    protected int compareTime(ERETime other) {
        int diff = 0;
        long otherMillis = other.getMillisecondsSinceEpoch() - other.getMillisecondsSinceEpoch() % 1000L;
        long diffLong = this.getMillisecondsSinceEpoch() - otherMillis;
        if (diffLong > 0L) {
            diff = 1;
        } else if (diffLong < 0L) {
            diff = -1;
        }
        return diff;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof ERETime) {
            return this.compareTo((ERETime)obj) == 0;
        }
        if (obj instanceof EREDate) {
            return this.compareTo((EREDate)obj) == 0;
        }
        if (obj instanceof Date) {
            return this.compareTo((Date)obj) == 0;
        }
        return false;
    }

    @Override
    public String toString() {
        return ERETimeUtil.makeISOStringFromERETime(this);
    }
}

