/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.datatype;

import com.ericsson.ere.dataset.OperationNotApplicableException;
import com.ericsson.ere.datatype.EREDate;
import com.ericsson.ere.datatype.EREDateFactory;
import com.ericsson.ere.datatype.EREDateUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DefaultEREDate
extends Date
implements EREDate {
    private static final TimeZone DEFAULT_TIMEZONE = TimeZone.getDefault();

    DefaultEREDate(long millis) {
        super(millis);
    }

    private DefaultEREDate() {
        super(DefaultEREDate.roundToWholeDay(System.currentTimeMillis()));
    }

    private DefaultEREDate(int daysSinceEpoch) {
        super(DefaultEREDate.roundToWholeDay((long)daysSinceEpoch * 86400000L));
    }

    private static long roundToWholeDay(long utc) {
        return EREDateUtil.getWholeDayTimeInMillis(utc, DEFAULT_TIMEZONE);
    }

    private DefaultEREDate(int year, int month, int dayOfMonth) {
        super(year - 1900, month - 1, dayOfMonth, 0, 0, 0);
    }

    public static DefaultEREDate today() {
        return new DefaultEREDate();
    }

    public static DefaultEREDate forDate(int year, int month, int dayOfMonth) {
        return new DefaultEREDate(year, month, dayOfMonth);
    }

    public static DefaultEREDate forDaysSinceEpoch(int days) {
        return new DefaultEREDate(days);
    }

    @Override
    public EREDate plusDays(int days) {
        if (days == 0) {
            return this;
        }
        DefaultEREDate clone = (DefaultEREDate)this.clone();
        clone.setDate(this.getDate() + days);
        return clone;
    }

    @Override
    public EREDate plusMonths(int months) {
        if (months == 0) {
            return this;
        }
        DefaultEREDate clone = (DefaultEREDate)this.clone();
        clone.setMonth(this.getMonth() + months);
        int expectedMonth = (this.getMonth() + months) % 12;
        if (expectedMonth < 0) {
            expectedMonth += 12;
        }
        if (clone.getMonth() != expectedMonth) {
            assert (clone.getMonth() == expectedMonth + 1);
            clone.setDate(0);
        }
        return clone;
    }

    @Override
    public EREDate plusYears(int years) {
        if (years == 0) {
            return this;
        }
        return this.plusMonths(12 * years);
    }

    @Override
    public Calendar asCalendar() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this);
        return cal;
    }

    @Override
    public Date asDate() {
        return this;
    }

    @Override
    public int getDaysSince19700101() {
        return EREDateUtil.convertLocalMillisSinceEpochToDays(this.getTime());
    }

    @Override
    public int compareTo(EREDate other) {
        if (other == this) {
            return 0;
        }
        if (other == BEGINNING_OF_TIME) {
            return 1;
        }
        if (other == END_OF_TIME) {
            return -1;
        }
        return this.getDaysSince19700101() - other.getDaysSince19700101();
    }

    @Override
    public int compareTo(Calendar other) {
        return this.compareTo(EREDateFactory.createFromCalendar(other));
    }

    @Override
    public int compareTo(Date other) {
        return this.compareTo(EREDateFactory.createFromDate(other));
    }

    @Override
    public String toString() {
        return String.format("%04d-%02d-%02d", 1900 + this.getYear(), 1 + this.getMonth(), this.getDate());
    }

    @Override
    public boolean isAfter(EREDate other) {
        return this.compareTo(other) > 0;
    }

    @Override
    public boolean isBefore(EREDate other) {
        return this.compareTo(other) < 0;
    }

    @Override
    public EREDate.WeekDay getDayOfWeek() {
        return EREDate.WeekDay.getFrom(this);
    }

    @Override
    public int daysUntil(EREDate other) {
        if (this == other) {
            return 0;
        }
        if (EREDateUtil.isBoundaryDate(other)) {
            throw new OperationNotApplicableException("Operation is not supported for boundary date constants.");
        }
        return other.getDaysSince19700101() - this.getDaysSince19700101();
    }

    @Override
    public int getDayOfMonth() {
        return this.getDate();
    }

    @Override
    public int getFullYear() {
        return this.getYear() + 1900;
    }

    @Override
    public int getMonthOfYear() {
        return this.getMonth() + 1;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof EREDate) {
            return this.compareTo((EREDate)obj) == 0;
        }
        if (obj instanceof Date) {
            return this.compareTo((Date)obj) == 0;
        }
        return false;
    }
}

