/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.dataset;

import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DefaultDataSet;
import com.ericsson.ere.dataset.RatingDataSet;
import com.ericsson.ere.dataset.task.ActiveTimeTask;
import com.ericsson.ere.dataset.task.ContinuousTimeTask;
import com.ericsson.ere.dataset.task.TimeBasedTask;
import com.ericsson.ere.math.RatingDecimal;
import ericsson.ere.management.DateUtil;
import ericsson.ere.management.Service;
import java.text.SimpleDateFormat;

public class RatingDataSetImpl
extends DefaultDataSet
implements RatingDataSet {
    RatingDecimal myTotalCost = new RatingDecimal(0L, 1L);
    RatingDecimal myCurrentPriceFactor = new RatingDecimal(1L, 1L);
    RatingDecimal myMoneyLeft = new RatingDecimal(100L, 1L);

    public RatingDataSetImpl() {
    }

    public RatingDataSetImpl(Service service) {
        super(service);
    }

    @Deprecated
    public RatingDataSetImpl(RatingDataSetImpl set) {
        throw new UnsupportedOperationException("Cloning via copy constructor not supported.");
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        RatingDataSetImpl set = (RatingDataSetImpl)super.clone();
        return set;
    }

    @Override
    public void allocateCost(RatingDecimal cost) {
        this.myTotalCost = this.myTotalCost.add(cost);
        if (!this.myMoneyLeft.isMinusOne()) {
            this.myMoneyLeft = this.myMoneyLeft.subtract(cost);
        }
    }

    @Override
    public RatingDecimal getCost() {
        return this.myTotalCost;
    }

    @Override
    public RatingDecimal getCurrentPriceFactor() {
        return this.myCurrentPriceFactor;
    }

    @Override
    public void setCurrentPriceFactor(RatingDecimal discount) {
        this.myCurrentPriceFactor = discount;
    }

    @Override
    public RatingDecimal getMoneyLeft() {
        return this.myMoneyLeft;
    }

    @Override
    public void setMaxCost(RatingDecimal cost) {
        this.myMoneyLeft = cost;
    }

    @Override
    public void setDurationToNextTimeSwitch(long nextSwitch) {
        this.myTask.setDurationToNextTimeSwitch(nextSwitch);
    }

    @Override
    public long getDurationToNextTimeSwitch() {
        return this.myTask.getDurationToNextTimeSwitch();
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer(super.toString());
        buf.append("\nMax cost: " + this.myMoneyLeft.toDotString(6, 4));
        if (this.myTask != null && this.myTask instanceof ContinuousTimeTask) {
            buf.append("\nMax duration: ").append(this.describeInSeconds(((ContinuousTimeTask)this.myTask).getRemainingDuration()));
        } else if (this.myTask != null && this.myTask instanceof ActiveTimeTask) {
            buf.append("\nMax duration: " + ((ActiveTimeTask)this.myTask).getRemainingDuration());
        }
        buf.append("\nCurrent cost: " + this.myTotalCost.toDotString(6, 4));
        buf.append("\n");
        return buf.toString();
    }

    protected String describeInSeconds(long amountOfTimeUnits) {
        return String.valueOf(amountOfTimeUnits);
    }

    protected String describeTimeUnits(long amountOfTimeUnits) {
        return DateUtil.formatSeconds(amountOfTimeUnits);
    }

    @Override
    public String diffDataSet(DataSet newSet) {
        StringBuffer buf = new StringBuffer(super.diffDataSet(newSet));
        buf.append("\n");
        RatingDataSet set = (RatingDataSet)newSet;
        buf.append("Total cost    : " + set.getCost().toDotString(4, 4) + "\n");
        if (this.getTreeTask() instanceof TimeBasedTask) {
            long totalDuration = ((TimeBasedTask)this.getTreeTask()).getTotalDuration();
            buf.append("Total duration: ").append(this.describeTimeUnits(totalDuration)).append(" (").append(this.describeInSeconds(totalDuration)).append(" sec) \n");
        }
        SimpleDateFormat sdfYear = new SimpleDateFormat(DateUtil.DATETIME_TEXT_FORMAT[0]);
        if (set.getTreeTask() != null && set.getTreeTask() instanceof TimeBasedTask) {
            TimeBasedTask task = (TimeBasedTask)set.getTreeTask();
            buf.append("\n");
            if (this.getCurrentTime().equals(set.getCurrentTime())) {
                buf.append("Time: " + sdfYear.format(this.getCurrentTime().getTime()) + "\n");
            } else {
                buf.append("Start time : " + sdfYear.format(this.getCurrentTime().getTime()) + "\n");
                buf.append("End time   : " + sdfYear.format(set.getCurrentTime().getTime()) + "\n");
            }
            if (this.getTreeTask() instanceof TimeBasedTask) {
                long allocatedDuration = task.getAllocatedDuration() - ((TimeBasedTask)this.getTreeTask()).getAllocatedDuration();
                buf.append("Allocated duration: ").append(this.describeTimeUnits(allocatedDuration)).append(" (").append(this.describeInSeconds(allocatedDuration)).append(" sec)\n");
            }
            buf.append("Total allocated duration: ").append(this.describeTimeUnits(task.getAllocatedDuration())).append(" (").append(this.describeInSeconds(task.getAllocatedDuration())).append(" sec)\n");
            buf.append("Duration to next time switch: " + (task.getDurationToNextTimeSwitch() == -1L ? "No timeswitch" : "" + DateUtil.formatSeconds(task.getDurationToNextTimeSwitch()) + " (" + task.getDurationToNextTimeSwitch() + " sec) ") + "\n");
        }
        return buf.toString();
    }
}

