/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.dataset;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.Key;
import com.ericsson.ere.datatype.EREDate;
import com.ericsson.ere.datatype.ERETime;
import com.ericsson.ere.math.RatingDecimal;
import ericsson.ere.datatype.Amount;
import ericsson.ere.datatype.BcdString;
import ericsson.ere.datatype.DataType;
import ericsson.ere.datatype.Decimal;
import ericsson.ere.datatype.MonetaryUnits;
import ericsson.ere.datatype.OctetString;
import ericsson.ere.datatype.Time;
import ericsson.ere.datatype.UnsignedInt16;
import ericsson.ere.datatype.UnsignedInt32;
import ericsson.ere.datatype.UnsignedInt8;
import ericsson.ere.defs.FieldDefinition;
import java.util.Collections;
import java.util.Date;

@Immutable
public class DataSetField {
    private final String myFieldName;
    private final boolean myUseTag;
    private final int myFieldTag;
    private final DataType myDataType;
    private final boolean myIsComplexType;
    private final FieldDefinition myField;
    private final boolean myIsHierarchicalField;

    public DataSetField(FieldDefinition field) {
        this(field, field.getTypedDataType());
    }

    public DataSetField(FieldDefinition field, DataType type) {
        this.myFieldName = field.getCanonicalName();
        this.myFieldTag = field.getTagNumber();
        this.myUseTag = field.usesTagNumber();
        this.myDataType = type;
        this.myIsComplexType = field.isComplexType();
        this.myField = field;
        this.myIsHierarchicalField = this.myField.getParent() != null || !this.myField.isLeaf();
    }

    public DataSetField(String fieldName, int tag, boolean useTag) {
        this(fieldName, tag, useTag, null);
    }

    public DataSetField(String fieldName, int tag, boolean useTag, DataType dataType) {
        this(fieldName, tag, useTag, dataType, false);
    }

    public DataSetField(String fieldName, int tag, boolean useTag, DataType dataType, boolean isComplexType) {
        this.myFieldName = fieldName;
        this.myUseTag = useTag;
        this.myFieldTag = tag;
        this.myDataType = dataType;
        this.myIsComplexType = isComplexType;
        this.myField = null;
        this.myIsHierarchicalField = false;
    }

    public Object getValueFromDataSet(DataSet ds) {
        Object result = this.myIsHierarchicalField ? ds.getAccessor().getValue(this.myField, null, this.myDataType) : (this.myDataType != null && !this.myIsComplexType ? this.getValueFromDataSetUsingMethodBasedOnDataType(ds) : (this.myUseTag ? ds.getDataAsObject(this.myFieldTag) : ds.getDataAsObject(this.myFieldName)));
        return result;
    }

    private Object getValueFromDataSetUsingMethodBasedOnDataType(DataSet ds) {
        switch (this.myDataType) {
            case AMOUNT: {
                return this.myUseTag ? ds.getDataAsAmount(this.myFieldTag) : ds.getDataAsAmount(this.myFieldName);
            }
            case BCDSTRING: {
                return this.myUseTag ? ds.getDataAsBcdString(this.myFieldTag) : ds.getDataAsBcdString(this.myFieldName);
            }
            case BOOLEAN: {
                return this.myUseTag ? ds.getDataAsBoolean(this.myFieldTag) : ds.getDataAsBoolean(this.myFieldName);
            }
            case DATE: {
                return this.myUseTag ? ds.getDataAsEREDate(this.myFieldTag) : ds.getDataAsEREDate(this.myFieldName);
            }
            case DECIMAL: {
                return this.myUseTag ? ds.getDataAsDecimal(this.myFieldTag) : ds.getDataAsDecimal(this.myFieldName);
            }
            case DOUBLE: {
                return this.myUseTag ? ds.getDataAsDouble(this.myFieldTag) : ds.getDataAsDouble(this.myFieldName);
            }
            case INTEGER: 
            case UNSIGNEDINT: {
                return this.myUseTag ? ds.getDataAsInt(this.myFieldTag) : ds.getDataAsInt(this.myFieldName);
            }
            case LONG: 
            case UNSIGNEDLONG: {
                return this.myUseTag ? ds.getDataAsLong(this.myFieldTag) : ds.getDataAsLong(this.myFieldName);
            }
            case MONETARYUNITS: {
                return this.myUseTag ? ds.getDataAsMonetaryUnits(this.myFieldTag) : ds.getDataAsMonetaryUnits(this.myFieldName);
            }
            case OCTETSTRING: {
                return this.myUseTag ? ds.getDataAsOctetString(this.myFieldTag) : ds.getDataAsOctetString(this.myFieldName);
            }
            case RATINGDECIMAL: {
                return this.myUseTag ? ds.getDataAsRatingDecimal(this.myFieldTag) : ds.getDataAsRatingDecimal(this.myFieldName);
            }
            case SHORT: 
            case UNSIGNEDSHORT: {
                return this.myUseTag ? ds.getDataAsShort(this.myFieldTag) : ds.getDataAsShort(this.myFieldName);
            }
            case STRING: {
                return this.myUseTag ? ds.getDataAsString(this.myFieldTag) : ds.getDataAsString(this.myFieldName);
            }
            case TIME: {
                return this.myUseTag ? ds.getDataAsERETime(this.myFieldTag) : ds.getDataAsERETime(this.myFieldName);
            }
            case UNSIGNEDINT16: {
                return this.myUseTag ? ds.getDataAsUnsignedInt16(this.myFieldTag) : ds.getDataAsUnsignedInt16(this.myFieldName);
            }
            case UNSIGNEDINT32: {
                return this.myUseTag ? ds.getDataAsUnsignedInt32(this.myFieldTag) : ds.getDataAsUnsignedInt32(this.myFieldName);
            }
            case UNSIGNEDINT8: {
                return this.myUseTag ? ds.getDataAsUnsignedInt8(this.myFieldTag) : ds.getDataAsUnsignedInt8(this.myFieldName);
            }
        }
        return this.myUseTag ? ds.getDataAsObject(this.myFieldTag) : ds.getDataAsObject(this.myFieldName);
    }

    public void setValueInDataSet(DataSet ds, Object value) {
        if (this.myIsHierarchicalField) {
            ds.getAccessor().setValue(this.myField, null, this.myDataType, value);
        } else if (this.myDataType != null && !this.myIsComplexType) {
            this.setValueInDataSetUsingMethodBasedOnDataType(ds, value);
        } else if (this.myUseTag) {
            ds.setDataAsObject(this.myFieldTag, value);
        } else {
            ds.setDataAsObject(this.myFieldName, value);
        }
    }

    private void setValueInDataSetUsingMethodBasedOnDataType(DataSet ds, Object value) {
        switch (this.myDataType) {
            case AMOUNT: {
                if (this.myUseTag) {
                    ds.setDataAsAmount(this.myFieldTag, (Amount)value);
                    break;
                }
                ds.setDataAsAmount(this.myFieldName, (Amount)value);
                break;
            }
            case BCDSTRING: {
                if (this.myUseTag) {
                    ds.setDataAsBcdString(this.myFieldTag, (BcdString)value);
                    break;
                }
                ds.setDataAsBcdString(this.myFieldName, (BcdString)value);
                break;
            }
            case BOOLEAN: {
                if (this.myUseTag) {
                    ds.setDataAsBoolean(this.myFieldTag, (boolean)((Boolean)value));
                    break;
                }
                ds.setDataAsBoolean(this.myFieldName, (boolean)((Boolean)value));
                break;
            }
            case DATE: {
                if (value instanceof EREDate) {
                    if (this.myUseTag) {
                        ds.setDataAsEREDate(this.myFieldTag, (EREDate)value);
                        break;
                    }
                    ds.setDataAsEREDate(this.myFieldName, (EREDate)value);
                    break;
                }
                if (this.myUseTag) {
                    ds.setDataAsDate(this.myFieldTag, (Date)value);
                    break;
                }
                ds.setDataAsDate(this.myFieldName, (Date)value);
                break;
            }
            case DECIMAL: {
                if (this.myUseTag) {
                    ds.setDataAsDecimal(this.myFieldTag, (Decimal)value);
                    break;
                }
                ds.setDataAsDecimal(this.myFieldName, (Decimal)value);
                break;
            }
            case DOUBLE: {
                if (this.myUseTag) {
                    ds.setDataAsDouble(this.myFieldTag, (double)((Double)value));
                    break;
                }
                ds.setDataAsDouble(this.myFieldName, (double)((Double)value));
                break;
            }
            case INTEGER: 
            case UNSIGNEDINT: {
                if (this.myUseTag) {
                    ds.setDataAsInt(this.myFieldTag, (int)((Integer)value));
                    break;
                }
                ds.setDataAsInt(this.myFieldName, (int)((Integer)value));
                break;
            }
            case LONG: 
            case UNSIGNEDLONG: {
                if (this.myUseTag) {
                    ds.setDataAsLong(this.myFieldTag, (long)((Long)value));
                    break;
                }
                ds.setDataAsLong(this.myFieldName, (long)((Long)value));
                break;
            }
            case MONETARYUNITS: {
                if (this.myUseTag) {
                    ds.setDataAsMonetaryUnits(this.myFieldTag, (MonetaryUnits)value);
                    break;
                }
                ds.setDataAsMonetaryUnits(this.myFieldName, (MonetaryUnits)value);
                break;
            }
            case OCTETSTRING: {
                if (this.myUseTag) {
                    ds.setDataAsOctetString(this.myFieldTag, (OctetString)value);
                    break;
                }
                ds.setDataAsOctetString(this.myFieldName, (OctetString)value);
                break;
            }
            case RATINGDECIMAL: {
                if (this.myUseTag) {
                    ds.setDataAsRatingDecimal(this.myFieldTag, (RatingDecimal)value);
                    break;
                }
                ds.setDataAsRatingDecimal(this.myFieldName, (RatingDecimal)value);
                break;
            }
            case SHORT: 
            case UNSIGNEDSHORT: {
                if (this.myUseTag) {
                    ds.setDataAsShort(this.myFieldTag, (short)((Short)value));
                    break;
                }
                ds.setDataAsShort(this.myFieldName, (short)((Short)value));
                break;
            }
            case STRING: {
                if (this.myUseTag) {
                    ds.setDataAsString(this.myFieldTag, (String)value);
                    break;
                }
                ds.setDataAsString(this.myFieldName, (String)value);
                break;
            }
            case TIME: {
                if (value instanceof ERETime) {
                    if (this.myUseTag) {
                        ds.setDataAsERETime(this.myFieldTag, (ERETime)value);
                        break;
                    }
                    ds.setDataAsERETime(this.myFieldName, (ERETime)value);
                    break;
                }
                if (this.myUseTag) {
                    ds.setDataAsTime(this.myFieldTag, (Time)value);
                    break;
                }
                ds.setDataAsTime(this.myFieldName, (Time)value);
                break;
            }
            case UNSIGNEDINT16: {
                if (this.myUseTag) {
                    ds.setDataAsUnsignedInt16(this.myFieldTag, (UnsignedInt16)value);
                    break;
                }
                ds.setDataAsUnsignedInt16(this.myFieldName, (UnsignedInt16)value);
                break;
            }
            case UNSIGNEDINT32: {
                if (this.myUseTag) {
                    ds.setDataAsUnsignedInt32(this.myFieldTag, (UnsignedInt32)value);
                    break;
                }
                ds.setDataAsUnsignedInt32(this.myFieldName, (UnsignedInt32)value);
                break;
            }
            case UNSIGNEDINT8: {
                if (this.myUseTag) {
                    ds.setDataAsUnsignedInt8(this.myFieldTag, (UnsignedInt8)value);
                    break;
                }
                ds.setDataAsUnsignedInt8(this.myFieldName, (UnsignedInt8)value);
                break;
            }
            default: {
                if (this.myUseTag) {
                    ds.setDataAsObject(this.myFieldTag, value);
                    break;
                }
                ds.setDataAsObject(this.myFieldName, value);
            }
        }
    }

    public Object getValueFromDataSet(DataSet ds, Key key) {
        Object value = key != null ? (this.myIsHierarchicalField ? ds.getAccessor().getValue(this.myField, Collections.singletonList(key), this.myDataType) : (this.myUseTag ? ds.getDataAsTypedObjectForKey(this.myFieldTag, key, this.myDataType) : ds.getDataAsTypedObjectForKey(this.myFieldName, key, this.myDataType))) : this.getValueFromDataSet(ds);
        return value;
    }

    public void setValueInDataSet(DataSet ds, Key key, Object value) {
        if (this.myIsHierarchicalField) {
            ds.getAccessor().setValue(this.myField, Collections.singletonList(key), this.myDataType, value);
        } else if (key != null) {
            if (this.myUseTag) {
                ds.setDataAsObjectForKey(this.myFieldTag, key, value);
            } else {
                ds.setDataAsObjectForKey(this.myFieldName, key, value);
            }
        } else {
            this.setValueInDataSet(ds, value);
        }
    }

    public String getFieldName() {
        return this.myFieldName;
    }

    public boolean usesTag() {
        return this.myUseTag;
    }

    public int getTag() {
        return this.myFieldTag;
    }

    public DataType getDataType() {
        return this.myDataType;
    }

    public boolean isComplexType() {
        return this.myIsComplexType;
    }

    public boolean doesDataExistInDataSet(DataSet dataSet) {
        if (this.myUseTag) {
            return dataSet.hasData(this.myFieldTag);
        }
        return dataSet.hasData(this.myFieldName);
    }

    public boolean doesDataExistInDataSet(DataSet dataSet, Key key) {
        if (this.myUseTag) {
            return dataSet.hasDataForKey(this.myFieldTag, key);
        }
        return dataSet.hasDataForKey(this.myFieldName, key);
    }

    public static DataSetFieldBuilder createDataSetField() {
        return new DataSetFieldBuilder();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myDataType == null ? 0 : this.myDataType.hashCode());
        result = 31 * result + (this.myField == null ? 0 : this.myField.hashCode());
        result = 31 * result + (this.myFieldName == null ? 0 : this.myFieldName.hashCode());
        result = 31 * result + this.myFieldTag;
        result = 31 * result + (this.myIsComplexType ? 1231 : 1237);
        result = 31 * result + (this.myIsHierarchicalField ? 1231 : 1237);
        result = 31 * result + (this.myUseTag ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataSetField other = (DataSetField)obj;
        if (this.myDataType != other.myDataType) {
            return false;
        }
        if (this.myField == null ? other.myField != null : !this.myField.equals(other.myField)) {
            return false;
        }
        if (this.myFieldName == null ? other.myFieldName != null : !this.myFieldName.equals(other.myFieldName)) {
            return false;
        }
        if (this.myFieldTag != other.myFieldTag) {
            return false;
        }
        if (this.myIsComplexType != other.myIsComplexType) {
            return false;
        }
        if (this.myIsHierarchicalField != other.myIsHierarchicalField) {
            return false;
        }
        return this.myUseTag == other.myUseTag;
    }

    public static class DataSetFieldBuilder {
        private String myFieldName = null;
        private int myFieldTag = -1;
        private DataType myDataType = null;
        private String myDefaultValueString = null;
        private boolean myIsComplexType = false;

        private DataSetFieldBuilder() {
        }

        public DataSetFieldBuilder withFieldName(String fieldName) {
            this.myFieldName = fieldName;
            return this;
        }

        public DataSetFieldBuilder withFieldTag(int fieldTag) {
            this.myFieldTag = fieldTag;
            return this;
        }

        public DataSetFieldBuilder withDataType(DataType dataType) {
            this.myDataType = dataType;
            return this;
        }

        public DataSetFieldBuilder andIsComplexType(boolean isComplexType) {
            this.myIsComplexType = isComplexType;
            return this;
        }

        public DataSetField get() {
            if (this.myFieldName == null && this.myFieldTag < 0) {
                throw new IllegalStateException("Cannot create DataSetField without identifier");
            }
            return new DataSetField(this.myFieldName, this.myFieldTag, this.myFieldTag >= 0, this.myDataType, this.myIsComplexType);
        }
    }
}

