/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.constraint.entity;

import com.ericsson.ere.constraint.entity.ConstraintTargetType;
import java.util.Locale;

public class ConstraintTarget
implements Comparable<ConstraintTarget> {
    private ConstraintTargetType myTargetType;
    private String myTargetValue;

    public static ConstraintTarget createTarget(ConstraintTargetType targetType, String targetValue) {
        if (targetType == null || targetValue == null) {
            throw new IllegalArgumentException("Arguments must not be null");
        }
        return new ConstraintTarget(targetType, targetValue);
    }

    public static ConstraintTarget createTargetForAll(ConstraintTargetType targetType) {
        return ConstraintTarget.createTarget(targetType, "*");
    }

    public boolean isAll() {
        return "*".equals(this.myTargetValue);
    }

    ConstraintTarget(ConstraintTargetType targetType, String targetValue) {
        this.myTargetType = targetType;
        this.myTargetValue = targetValue;
    }

    public ConstraintTargetType getTargetType() {
        return this.myTargetType;
    }

    public String getTargetValue() {
        return this.myTargetValue;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myTargetType == null ? 0 : this.myTargetType.hashCode());
        result = 31 * result + (this.myTargetValue == null ? 0 : this.myTargetValue.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConstraintTarget other = (ConstraintTarget)obj;
        if (this.myTargetType == null ? other.myTargetType != null : !this.myTargetType.equals((Object)other.myTargetType)) {
            return false;
        }
        return !(this.myTargetValue == null ? other.myTargetValue != null : !this.myTargetValue.equals(other.myTargetValue));
    }

    @Override
    public int compareTo(ConstraintTarget o) {
        if (this.isAll()) {
            return o.isAll() ? 0 : -1;
        }
        return o.isAll() ? 1 : 0;
    }

    public String toString() {
        return this.describe(Locale.US);
    }

    public String describe(Locale locale) {
        String tt = this.myTargetType.getName().toLowerCase();
        if (this.isAll()) {
            return "all " + tt + "s";
        }
        return tt + " '" + this.myTargetValue + "'";
    }
}

