/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.constraint.contract;

import com.ericsson.ere.constraint.contract.Constrainable;
import com.ericsson.ere.constraint.contract.ConstrainableContract;
import com.ericsson.ere.constraint.contract.ConstrainableProfileContract;
import com.ericsson.ere.constraint.contract.ConstrainableProfileContractContext;
import com.ericsson.ere.constraint.entity.Constrainable;
import com.ericsson.ere.selectiontree.conditions.DummyConditionProfile;
import com.ericsson.ere.selectiontree.modifiers.DummyModifierProfile;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.EreClassLoader;
import ericsson.ere.defs.PluginName;
import ericsson.ere.interfaces.ClassProfile;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;

public final class ConstrainableService {
    private ClassRepository myRepository;

    private ConstrainableService(ClassRepository repository) {
        this.myRepository = repository;
    }

    public static ConstrainableService forRepository(ClassRepository repository) {
        return new ConstrainableService(repository);
    }

    public Collection<com.ericsson.ere.constraint.entity.Constrainable> getConstrainableConditions() throws ClassNotFoundException {
        Class<?> profileClass;
        String profileClassName;
        ArrayList<com.ericsson.ere.constraint.entity.Constrainable> list = new ArrayList<com.ericsson.ere.constraint.entity.Constrainable>();
        for (PluginName conditionName : this.myRepository.getDefinedConditionList()) {
            profileClassName = this.myRepository.getConditionProfileClassName(conditionName.getName());
            profileClass = EreClassLoader.getClass(profileClassName);
            if (!this.isProfileClass(profileClass) || !ConstrainableService.isProfileConstrainable(profileClass)) continue;
            list.add(com.ericsson.ere.constraint.entity.Constrainable.createFromNameAndType(conditionName.getName(), Constrainable.ConstrainableType.CONDITION));
        }
        for (PluginName conditionName : this.myRepository.getBaseConditionList()) {
            profileClassName = this.myRepository.getBaseConditionProfile(conditionName.getName());
            profileClass = EreClassLoader.getClass(profileClassName);
            if (!this.isProfileClass(profileClass) || !ConstrainableService.isProfileConstrainable(profileClass)) continue;
            list.add(com.ericsson.ere.constraint.entity.Constrainable.createFromNameAndType(conditionName.getName(), Constrainable.ConstrainableType.CONDITION));
        }
        return list;
    }

    private boolean isProfileClass(Class<?> clazz) {
        return ClassProfile.class.isAssignableFrom(clazz);
    }

    public Collection<com.ericsson.ere.constraint.entity.Constrainable> getConstrainableModifiers() throws ClassNotFoundException {
        ArrayList<com.ericsson.ere.constraint.entity.Constrainable> list = new ArrayList<com.ericsson.ere.constraint.entity.Constrainable>();
        for (PluginName modifierName : this.myRepository.getModifierList()) {
            String profileClassName = this.myRepository.getModifierProfileClassName(modifierName.getName());
            Class<?> profileClass = EreClassLoader.getClass(profileClassName);
            if (!this.isProfileClass(profileClass) || !ConstrainableService.isProfileConstrainable(profileClass)) continue;
            list.add(com.ericsson.ere.constraint.entity.Constrainable.createFromNameAndType(modifierName.getName(), Constrainable.ConstrainableType.MODIFIER));
        }
        return list;
    }

    public Collection<com.ericsson.ere.constraint.entity.Constrainable> getConstrainableNodes() throws ClassNotFoundException {
        ArrayList<com.ericsson.ere.constraint.entity.Constrainable> list = new ArrayList<com.ericsson.ere.constraint.entity.Constrainable>();
        for (String nodeType : this.myRepository.getNodeTypeNames()) {
            String profileClassName = this.myRepository.getNodeTypeProfileClassName(nodeType);
            Class<?> profileClass = EreClassLoader.getClass(profileClassName);
            if (!this.isProfileClass(profileClass) || !ConstrainableService.isProfileConstrainable(profileClass)) continue;
            list.add(com.ericsson.ere.constraint.entity.Constrainable.createFromNameAndType(nodeType, Constrainable.ConstrainableType.NODE));
        }
        return list;
    }

    public Collection<com.ericsson.ere.constraint.entity.Constrainable> getConstrainableTariffStructures() throws ClassNotFoundException {
        ArrayList<com.ericsson.ere.constraint.entity.Constrainable> list = new ArrayList<com.ericsson.ere.constraint.entity.Constrainable>();
        for (String name : this.myRepository.getTariffStructureNames()) {
            String profileClassName = this.myRepository.getTariffStructureProfileClassName(name);
            Class<?> profileClass = EreClassLoader.getClass(profileClassName);
            if (!this.isProfileClass(profileClass) || !ConstrainableService.isProfileConstrainable(profileClass)) continue;
            list.add(com.ericsson.ere.constraint.entity.Constrainable.createFromNameAndType(name, Constrainable.ConstrainableType.TARIFF_STRUCTURE));
        }
        return list;
    }

    public Collection<com.ericsson.ere.constraint.entity.Constrainable> getConstrainablePlugins() throws ClassNotFoundException {
        ArrayList<com.ericsson.ere.constraint.entity.Constrainable> list = new ArrayList<com.ericsson.ere.constraint.entity.Constrainable>();
        list.addAll(this.getConstrainableConditions());
        list.addAll(this.getConstrainableModifiers());
        list.addAll(this.getConstrainableNodes());
        list.addAll(this.getConstrainableTariffStructures());
        return list;
    }

    public static boolean isProfileConstrainable(Class<? extends ClassProfile> profileClass) {
        return profileClass.isAnnotationPresent(Constrainable.class) || profileClass.isAnnotationPresent(ConstrainableContract.class);
    }

    public ConstrainableProfileContract getContractForProfile(Class<? extends ClassProfile> profileClass) {
        if (!ConstrainableService.isProfileConstrainable(profileClass)) {
            throw new IllegalArgumentException("Class " + profileClass + " is not constrainable.");
        }
        Class<? extends ConstrainableProfileContract> contractClass = this.getContractClassFromConstrainableProfile(profileClass);
        ConstrainableProfileContract contract = null;
        try {
            contract = this.createContractInstance(contractClass, profileClass);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException("No public create method found in class " + contractClass, ex);
        }
        catch (IllegalAccessException ex) {
            throw new AssertionError((Object)ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException("The create method in class " + contractClass + " threw an exception.", ex.getCause());
        }
        return contract;
    }

    private Class<? extends ConstrainableProfileContract> getContractClassFromConstrainableProfile(Class<? extends ClassProfile> profileClass) {
        Class<? extends ConstrainableProfileContract> contractClass;
        if (profileClass.isAnnotationPresent(ConstrainableContract.class)) {
            ConstrainableContract annot = profileClass.getAnnotation(ConstrainableContract.class);
            contractClass = annot.contractClass();
        } else {
            Constrainable annot = profileClass.getAnnotation(Constrainable.class);
            contractClass = annot.contractClass();
        }
        return contractClass;
    }

    private ConstrainableProfileContract createContractInstance(Class<? extends ConstrainableProfileContract> contractClass, Class<? extends ClassProfile> profileClass) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method createMethod;
        boolean hasExtendedCreate = false;
        boolean hasExtendedCompactCreate = false;
        try {
            createMethod = contractClass.getMethod("create", ConstrainableProfileContractContext.class);
            hasExtendedCompactCreate = true;
        }
        catch (NoSuchMethodException e) {
            try {
                createMethod = contractClass.getMethod("create", ClassRepository.class, Class.class);
                hasExtendedCreate = true;
            }
            catch (NoSuchMethodException e2) {
                createMethod = contractClass.getMethod("create", ClassRepository.class);
            }
        }
        if (!Modifier.isStatic(createMethod.getModifiers())) {
            throw new IllegalArgumentException("The create method in class " + contractClass + " is not static.");
        }
        Class<?> returnType = createMethod.getReturnType();
        if (!ConstrainableProfileContract.class.isAssignableFrom(returnType)) {
            throw new IllegalArgumentException(String.format("The create method in class %s does not have a return type compatible with  %s.", contractClass, ConstrainableProfileContract.class.getSimpleName()));
        }
        ConstrainableProfileContract contract = hasExtendedCompactCreate ? (ConstrainableProfileContract)createMethod.invoke(null, this.createContext(profileClass)) : (hasExtendedCreate ? (ConstrainableProfileContract)createMethod.invoke(null, this.myRepository, profileClass) : (ConstrainableProfileContract)createMethod.invoke(null, this.myRepository));
        return contract;
    }

    private ConstrainableProfileContractContext createContext(final Class<? extends ClassProfile> profileClass) {
        final String name = this.findPluginName(profileClass);
        return new ConstrainableProfileContractContext(){

            @Override
            public ClassRepository getClassRepository() {
                return ConstrainableService.this.myRepository;
            }

            @Override
            public Class<? extends ClassProfile> getProfileClass() {
                return profileClass;
            }

            @Override
            public String getProfileName() {
                return name;
            }
        };
    }

    private String findPluginName(Class<? extends ClassProfile> profileClass) {
        String pc;
        String name = null;
        for (PluginName pn : this.myRepository.getDefinedConditionList()) {
            pc = this.myRepository.getConditionProfileClassName(pn.getName());
            if (!profileClass.getName().equals(pc)) continue;
            name = pn.getName();
            break;
        }
        if (name == null) {
            for (PluginName pn : this.myRepository.getModifierList()) {
                pc = this.myRepository.getModifierProfileClassName(pn.getName());
                if (!profileClass.getName().equals(pc)) continue;
                name = pn.getName();
                break;
            }
            if (name == null) {
                for (String nn : this.myRepository.getNodeTypeNames()) {
                    String pc2 = this.myRepository.getNodeTypeProfileClassName(nn);
                    if (!profileClass.getName().equals(pc2)) continue;
                    name = nn;
                    break;
                }
            }
        }
        return name;
    }

    public ConstrainableProfileContract getContractForConstrainable(com.ericsson.ere.constraint.entity.Constrainable cid) {
        switch (cid.getType()) {
            case CONDITION: {
                return this.getContractForCondition(cid.getName());
            }
            case MODIFIER: {
                return this.getContractForModifier(cid.getName());
            }
            case NODE: {
                return this.getContractForNode(cid.getName());
            }
            case TARIFF_STRUCTURE: {
                return this.getContractForTariffStructure(cid.getName());
            }
        }
        throw new AssertionError((Object)("Unhandled type: " + (Object)((Object)cid.getType())));
    }

    public ConstrainableProfileContract getContractForCondition(String conditionName) {
        String profileClass = this.myRepository.getConditionProfileClassName(conditionName);
        if (this.isInvalidConditionProfile(profileClass)) {
            profileClass = this.myRepository.getBaseConditionProfile(conditionName);
        }
        if (this.isInvalidConditionProfile(profileClass)) {
            throw new IllegalArgumentException("Unknown condition: " + conditionName);
        }
        return this.loadClassAndGetContract(conditionName, profileClass);
    }

    private boolean isInvalidConditionProfile(String profileClass) {
        return profileClass == null || profileClass.equals(DummyConditionProfile.class.getName());
    }

    private boolean isInvalidModifierProfile(String profileClass) {
        return profileClass == null || profileClass.equals(DummyModifierProfile.class.getName());
    }

    private boolean isInvalidNodeProfile(String profileClass) {
        return profileClass == null;
    }

    private boolean isInvalidTariffStructureProfile(String profileClass) {
        return profileClass == null;
    }

    public ConstrainableProfileContract getContractForModifier(String modifierName) {
        String profileClass = this.myRepository.getModifierProfileClassName(modifierName);
        if (this.isInvalidModifierProfile(profileClass)) {
            throw new IllegalArgumentException("Unknown modifier: " + modifierName);
        }
        return this.loadClassAndGetContract(modifierName, profileClass);
    }

    public ConstrainableProfileContract getContractForNode(String nodeName) {
        String profileClass = this.myRepository.getNodeTypeProfileClassName(nodeName);
        if (this.isInvalidNodeProfile(profileClass)) {
            throw new IllegalArgumentException("Unknown node type: " + nodeName);
        }
        return this.loadClassAndGetContract(nodeName, profileClass);
    }

    public ConstrainableProfileContract getContractForTariffStructure(String tariffStructureName) {
        String profileClass = this.myRepository.getTariffStructureProfileClassName(tariffStructureName);
        if (this.isInvalidTariffStructureProfile(profileClass)) {
            throw new IllegalArgumentException("Unknown tariff structure type: " + tariffStructureName);
        }
        return this.loadClassAndGetContract(tariffStructureName, profileClass);
    }

    private ConstrainableProfileContract loadClassAndGetContract(String name, String profileClass) {
        Class<?> clazz;
        try {
            clazz = EreClassLoader.getClass(profileClass);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("Profile class not found for " + name, ex);
        }
        return this.getContractForProfile(clazz);
    }
}

