/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.validators.impl;

import com.ericsson.em.validators.NotAllEmpty;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.ValidationException;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Optional;

public class NotAllEmptyValidator
implements ConstraintValidator<NotAllEmpty, Object> {
    private String[] properties;

    @Override
    public void initialize(NotAllEmpty annotation) {
        this.properties = annotation.properties();
    }

    @Override
    public boolean isValid(Object instance, ConstraintValidatorContext context) {
        if (this.properties == null || this.properties.length == 0) {
            throw new IllegalArgumentException("At least one property should be set.");
        }
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(instance.getClass());
            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
            PropertyDescriptor propertyDescriptor = null;
            for (String property : this.properties) {
                Object value;
                for (PropertyDescriptor pd : propertyDescriptors) {
                    if (!pd.getName().equals(property)) continue;
                    propertyDescriptor = pd;
                }
                if (propertyDescriptor == null) {
                    throw new IllegalArgumentException("no property for: " + property);
                }
                Method getter = propertyDescriptor.getReadMethod();
                if (getter == null) {
                    throw new IllegalArgumentException("no getter exists for: " + property);
                }
                if (String.class.equals(propertyDescriptor.getPropertyType())) {
                    value = (String)getter.invoke(instance, new Object[0]);
                    if (value == null || ((String)value).trim().isEmpty()) continue;
                    return true;
                }
                if (Collection.class.isAssignableFrom(propertyDescriptor.getPropertyType())) {
                    value = (Collection)getter.invoke(instance, new Object[0]);
                    if (value == null || value.isEmpty()) continue;
                    return true;
                }
                if (Optional.class.equals(propertyDescriptor.getPropertyType())) {
                    value = (Optional)getter.invoke(instance, new Object[0]);
                    if (value == null || !((Optional)value).isPresent() || ((Optional)value).equals(Optional.empty()) || ((Optional)value).equals(Optional.of(""))) continue;
                    return true;
                }
                throw new ValidationException("Unsupported field type: " + propertyDescriptor.getPropertyType().getSimpleName());
            }
        }
        catch (Exception e) {
            throw new ValidationException(e);
        }
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate("{NotAllEmpty.message}").addNode(this.getPropertyNames()).addConstraintViolation();
        return false;
    }

    private String getPropertyNames() {
        StringBuilder builder = new StringBuilder("[");
        for (String property : this.properties) {
            builder.append(property).append(",");
        }
        return builder.substring(0, builder.length() - 1) + "]";
    }
}

