/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.validators.impl;

import com.ericsson.em.validators.IsURI;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.net.URI;
import java.net.URISyntaxException;

public class IsURIValidator
implements ConstraintValidator<IsURI, String> {
    private boolean allowQuery;

    @Override
    public void initialize(IsURI annotation) {
        this.allowQuery = annotation.allowQuery();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext constraintValidatorContext) {
        if (value == null) {
            return true;
        }
        try {
            URI uri = new URI(value);
            if (!this.allowQuery) {
                String query = uri.getQuery();
                return query == null;
            }
            return true;
        }
        catch (URISyntaxException e) {
            return false;
        }
    }
}

