/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.validators.impl;

import com.ericsson.em.validators.IsIntegerWithinRange;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;

public class IsIntegerWithinRangeValidator
implements ConstraintValidator<IsIntegerWithinRange, Integer> {
    private int min;
    private int max;
    private boolean allowNull;

    @Override
    public void initialize(IsIntegerWithinRange paramA) {
        this.min = paramA.min();
        this.max = paramA.max();
        this.allowNull = paramA.allowNull();
        this.validateParameters();
    }

    @Override
    public boolean isValid(Integer integer, ConstraintValidatorContext constraintValidatorContext) {
        if (integer == null) {
            return this.allowNull;
        }
        try {
            if (integer >= this.min && integer <= this.max) {
                return true;
            }
            constraintValidatorContext.disableDefaultConstraintViolation();
            constraintValidatorContext.buildConstraintViolationWithTemplate("{IsIntegerWithinRange.message}").addConstraintViolation();
            return false;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private void validateParameters() {
        if (this.max < this.min) {
            throw new IllegalArgumentException("Max should be greater than min.");
        }
    }
}

