/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.validators.impl;

import com.ericsson.em.validators.IsFilesystemPath;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.io.File;
import java.util.regex.Pattern;

public class IsFilesystemPathValidator
implements ConstraintValidator<IsFilesystemPath, String> {
    private final Pattern mInvalidCharacters = Pattern.compile("[<>!@#$%^&*(){}\\[\\]\\\\+|=~;?,'\"`\\n\\r]|://|(\\.\\.)+");

    @Override
    public void initialize(IsFilesystemPath constraintAnnotation) {
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        if (value.length() == 0 || this.mInvalidCharacters.matcher(value).find()) {
            return false;
        }
        File f = new File(value);
        return !f.isAbsolute();
    }
}

