/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.validators.impl;

import com.ericsson.em.validators.ConditionallyRequired;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.ValidationException;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ConditionallyRequiredValidator
implements ConstraintValidator<ConditionallyRequired, Object> {
    private String condition;
    private String[] required;

    @Override
    public void initialize(ConditionallyRequired annotation) {
        this.condition = annotation.condition();
        this.required = annotation.required();
    }

    @Override
    public boolean isValid(Object instance, ConstraintValidatorContext context) {
        boolean allOk;
        block6: {
            if (this.condition == null) {
                throw new IllegalArgumentException("The condition property must be set.");
            }
            if (this.required == null || this.required.length == 0) {
                throw new IllegalArgumentException("At least one required property must be set.");
            }
            allOk = true;
            try {
                BeanInfo beanInfo = Introspector.getBeanInfo(instance.getClass());
                PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
                if (this.getValue(instance, propertyDescriptors, this.condition) == null) break block6;
                for (String property : this.required) {
                    Object value = this.getValue(instance, propertyDescriptors, property);
                    if (value != null) continue;
                    allOk = false;
                    break;
                }
            }
            catch (Exception e) {
                throw new ValidationException(e);
            }
        }
        if (allOk) {
            return true;
        }
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate("{ConditionallyRequired.message}").addNode(this.condition).addNode(this.getPropertyNames()).addConstraintViolation();
        return false;
    }

    private Object getValue(Object instance, PropertyDescriptor[] propertyDescriptors, String property) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        PropertyDescriptor propertyDescriptor = null;
        for (PropertyDescriptor pd : propertyDescriptors) {
            if (!pd.getName().equals(property)) continue;
            propertyDescriptor = pd;
        }
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException("no property for: " + property);
        }
        Method getter = propertyDescriptor.getReadMethod();
        if (getter == null) {
            throw new IllegalArgumentException("no getter exists for: " + property);
        }
        return getter.invoke(instance, new Object[0]);
    }

    private String getPropertyNames() {
        StringBuilder builder = new StringBuilder("[");
        for (String property : this.required) {
            builder.append(property).append(",");
        }
        return builder.substring(0, builder.length() - 1) + "]";
    }
}

