/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.validators.impl;

import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.ValidationException;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.stream.Collectors;

public abstract class AbstractNumberOfPropertiesSetValidatorBase {
    protected String[] properties;

    protected abstract boolean isNumberOfNonNullOk(int var1);

    protected abstract String getMessageTemplateName();

    protected boolean isValid(Object instance, ConstraintValidatorContext context) {
        if (this.properties == null || this.properties.length < 2) {
            throw new IllegalArgumentException("At least two properties should be set.");
        }
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(instance.getClass());
            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
            int nonNull = 0;
            for (String property : this.properties) {
                if (AbstractNumberOfPropertiesSetValidatorBase.getValue(instance, propertyDescriptors, property) == null) continue;
                ++nonNull;
            }
            if (this.isNumberOfNonNullOk(nonNull)) {
                return true;
            }
        }
        catch (Exception e) {
            throw new ValidationException(e);
        }
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(this.getMessageTemplateName()).addNode(this.getPropertyNames()).addConstraintViolation();
        return false;
    }

    private static Object getValue(Object instance, PropertyDescriptor[] propertyDescriptors, String property) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        PropertyDescriptor propertyDescriptor = AbstractNumberOfPropertiesSetValidatorBase.getPropertyDescriptor(propertyDescriptors, property);
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException("no property for: " + property);
        }
        Method getter = propertyDescriptor.getReadMethod();
        if (getter == null) {
            throw new IllegalArgumentException("no getter exists for: " + property);
        }
        return getter.invoke(instance, new Object[0]);
    }

    private static PropertyDescriptor getPropertyDescriptor(PropertyDescriptor[] propertyDescriptors, String property) {
        for (PropertyDescriptor pd : propertyDescriptors) {
            if (!pd.getName().equals(property)) continue;
            return pd;
        }
        return null;
    }

    private String getPropertyNames() {
        String csv = Arrays.stream(this.properties).collect(Collectors.joining(","));
        return "[" + csv + "]";
    }
}

