/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.validation;

import com.ericsson.em.validation.Languages;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

class LanguagesLoader {
    private static final Pattern CONFIGURATION_ENTRY_FORMAT = Pattern.compile("^([a-z]{2,3})=(.{1,150})");

    LanguagesLoader() {
    }

    Map<String, String> loadFrom(String languagesResourceFileName) {
        Map<String, String> map;
        InputStream inputStream = Languages.class.getResourceAsStream(languagesResourceFileName);
        if (inputStream == null) {
            throw new RuntimeException("Can't load resource: " + languagesResourceFileName);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        try {
            map = reader.lines().map(String::trim).filter(this::isConfigurationLine).map(this::extractConfigurationRecords).collect(Collectors.toMap(ConfigurationEntry::getLanguageCode, ConfigurationEntry::getLanguageName));
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException exception) {
                throw new RuntimeException("Failed while loading " + languagesResourceFileName, exception);
            }
        }
        reader.close();
        return map;
    }

    private boolean isConfigurationLine(String line) {
        return !line.isEmpty() && !line.startsWith("#") && !line.startsWith("!");
    }

    private ConfigurationEntry extractConfigurationRecords(String line) {
        Matcher matcher = CONFIGURATION_ENTRY_FORMAT.matcher(line);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid language configuration: '" + line + "' The line must match: " + CONFIGURATION_ENTRY_FORMAT.toString());
        }
        return new ConfigurationEntry(matcher.group(1), matcher.group(2));
    }

    private static class ConfigurationEntry {
        final String languageCode;
        final String languageName;

        ConfigurationEntry(String languageCode, String languageName) {
            this.languageCode = languageCode;
            this.languageName = languageName;
        }

        String getLanguageCode() {
            return this.languageCode;
        }

        String getLanguageName() {
            return this.languageName;
        }
    }
}

