/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.v1_3.common;

import com.ericsson.em.m3if.v1_0.common.Iso8601DateTime;
import com.ericsson.em.m3if.v1_2.common.RecurringInfo;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.joda.time.DateTime;
import org.joda.time.base.AbstractInstant;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/v1_3/common", name="scheduledtransactiondate", propOrder={"scheduledDateTime", "recurringInfo"})
public class ScheduledTransactionDate
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NotNull
    @Valid
    @XmlElement(name="scheduleddatetime", type=Iso8601DateTime.class, required=true)
    private Iso8601DateTime scheduledDateTime;
    @Valid
    @XmlElement(name="recurringinfo", type=RecurringInfo.class)
    private RecurringInfo recurringInfo;

    public ScheduledTransactionDate() {
    }

    public ScheduledTransactionDate(DateTime date) {
        this.scheduledDateTime = Iso8601DateTime.fromDateTime(date.toDateTime());
    }

    public ScheduledTransactionDate(DateTime date, RecurringInfo recurringInfo) {
        this(date);
        this.recurringInfo = recurringInfo;
    }

    public AbstractInstant getScheduledDateTime() {
        return this.scheduledDateTime.getValueAsDateTime();
    }

    public void setScheduledDateTime(AbstractInstant date) {
        this.scheduledDateTime = Iso8601DateTime.fromDateTime(date.toDateTime());
    }

    public RecurringInfo getRecurringInfo() {
        return this.recurringInfo;
    }

    public void setRecurringInfo(RecurringInfo recurringInfo) {
        this.recurringInfo = recurringInfo;
    }
}

