/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.v1_2.common;

import com.ericsson.em.m3if.operations.validation.IsPositiveAmount;
import com.ericsson.em.m3if.v1_0.common.FirstnameValue;
import com.ericsson.em.m3if.v1_0.common.Iso8601DateTime;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.m3if.v1_0.common.MsisdnValue;
import com.ericsson.em.m3if.v1_0.common.SurnameValue;
import com.ericsson.em.validators.IsSingleWordString;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="transferinitiatedetails", namespace="http://www.ericsson.com/em/emm/v1_2/common", propOrder={"amount", "approvalExpiryTime", "approvingAccountHolderMsisdn", "approvingAccountHolderFirstName", "approvingAccountHolderSurname", "status"})
public class TransferInitiateDetails
implements Serializable {
    private static final long serialVersionUID = 1L;
    @IsPositiveAmount
    @Valid
    @XmlElement(name="amount")
    private MoneyDetails amount;
    @NotNull
    @Valid
    @XmlElement(name="approvalexpirytime", required=true)
    private Iso8601DateTime approvalExpiryTime;
    @Valid
    @XmlElement(name="approvingaccountholdermsisdn")
    private MsisdnValue approvingAccountHolderMsisdn;
    @Valid
    @XmlElement(name="approvingaccountholderfirstname")
    private FirstnameValue approvingAccountHolderFirstName;
    @Valid
    @XmlElement(name="approvingaccountholdersurname")
    private SurnameValue approvingAccountHolderSurname;
    @IsSingleWordString
    @NotNull
    @XmlElement(name="status", required=true)
    private String status;

    public MoneyDetails getAmount() {
        return this.amount;
    }

    public Iso8601DateTime getApprovalExpiryTime() {
        return this.approvalExpiryTime;
    }

    public MsisdnValue getApprovingAccountHolderMsisdn() {
        return this.approvingAccountHolderMsisdn;
    }

    public String getStatus() {
        return this.status;
    }

    public void setAmount(MoneyDetails amount) {
        this.amount = amount;
    }

    public void setApprovalExpiryTime(Iso8601DateTime approvalExpiryTime) {
        this.approvalExpiryTime = approvalExpiryTime;
    }

    public void setApprovingAccountHolderMsisdn(String approvingAccountHolderMsisdn) {
        this.approvingAccountHolderMsisdn = MsisdnValue.fromString(approvingAccountHolderMsisdn);
    }

    public void setApprovingAccountHolderMsisdn(MsisdnValue approvingAccountHolderMsisdn) {
        this.approvingAccountHolderMsisdn = approvingAccountHolderMsisdn;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public FirstnameValue getApprovingAccountHolderFirstName() {
        return this.approvingAccountHolderFirstName;
    }

    public void setApprovingAccountHolderFirstName(String approvingAccountHolderFirstName) {
        this.approvingAccountHolderFirstName = FirstnameValue.fromString(approvingAccountHolderFirstName);
    }

    public void setApprovingAccountHolderFirstName(FirstnameValue approvingAccountHolderFirstName) {
        this.approvingAccountHolderFirstName = approvingAccountHolderFirstName;
    }

    public SurnameValue getApprovingAccountHolderSurname() {
        return this.approvingAccountHolderSurname;
    }

    public void setApprovingAccountHolderSurname(String approvingAccountHolderSurname) {
        this.approvingAccountHolderSurname = SurnameValue.fromString(approvingAccountHolderSurname);
    }

    public void setApprovingAccountHolderSurname(SurnameValue approvingAccountHolderSurname) {
        this.approvingAccountHolderSurname = approvingAccountHolderSurname;
    }
}

