/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.v1_2.common;

import com.ericsson.em.m3if.operations.utils.DateHelper;
import com.ericsson.em.m3if.v1_0.common.Iso8601Date;
import com.ericsson.em.m3if.v1_0.common.Iso8601DateTime;
import com.ericsson.em.m3if.v1_1.common.RecurringInfo;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.sql.Date;
import java.time.Instant;
import java.time.ZoneId;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.base.AbstractInstant;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/v1_2/common", name="scheduledtransactiondate", propOrder={"date", "recurringInfo"})
@Deprecated
public class ScheduledTransactionDate
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NotNull
    @Valid
    @XmlElement(name="date", type=Iso8601Date.class, required=true)
    private Iso8601Date date;
    @Valid
    @XmlElement(name="recurringinfo", type=RecurringInfo.class)
    private RecurringInfo recurringInfo;

    public ScheduledTransactionDate() {
    }

    public ScheduledTransactionDate(DateTime date) {
        this.date = ScheduledTransactionDate.getIso8601DateFromDateTime(date);
    }

    public ScheduledTransactionDate(LocalDate date) {
        this.date = date == null ? null : Iso8601Date.fromLocalDate(date);
    }

    public ScheduledTransactionDate(DateTime date, RecurringInfo recurringInfo) {
        this(date);
        this.recurringInfo = recurringInfo;
    }

    public ScheduledTransactionDate(LocalDate date, RecurringInfo recurringInfo) {
        this(date);
        this.recurringInfo = recurringInfo;
    }

    public LocalDate getLocalDate() {
        Instant instant = ScheduledTransactionDate.getInstant(this.date);
        if (instant != null) {
            return DateHelper.dateMidnightFromDate(Date.from(instant)).toLocalDate();
        }
        return null;
    }

    public AbstractInstant getDate() {
        LocalDate localDate = this.getLocalDate();
        if (localDate != null) {
            return DateHelper.dateMidnightFromDate(localDate.toDate());
        }
        return null;
    }

    public void setDate(AbstractInstant date) {
        this.date = ScheduledTransactionDate.getIso8601DateFromDateTime(date.toDateTime());
    }

    public RecurringInfo getRecurringInfo() {
        return this.recurringInfo;
    }

    public void setRecurringInfo(RecurringInfo recurringInfo) {
        this.recurringInfo = recurringInfo;
    }

    private static Instant getInstant(Iso8601Date date) {
        if (date != null) {
            return date.getValueAsLocalDate().atStartOfDay().atZone(ZoneId.systemDefault()).toInstant();
        }
        return null;
    }

    private static Iso8601Date getIso8601DateFromDateTime(DateTime date) {
        Iso8601DateTime iso8601DateTime = Iso8601DateTime.fromDateTime(date);
        if (iso8601DateTime != null) {
            return Iso8601Date.fromLocalDate(iso8601DateTime.getValueAsZonedDateTime().toLocalDate());
        }
        return null;
    }
}

