/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.v1_0.common;

import com.ericsson.em.m3if.operations.adapter.DateAdapter;
import com.ericsson.em.m3if.operations.annotations.SensitiveValue;
import com.ericsson.em.m3if.operations.utils.DateHelper;
import com.ericsson.em.m3if.operations.validation.IsPositiveAmount;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.m3if.v1_0.common.VoucherStatus;
import com.ericsson.em.validators.IsFinancialResourceIdentifier;
import com.ericsson.em.validators.IsFirstname;
import com.ericsson.em.validators.IsMultiWordString;
import com.ericsson.em.validators.IsMultilineRestrictedString;
import com.ericsson.em.validators.IsSecretString;
import com.ericsson.em.validators.IsSurname;
import com.ericsson.em.validators.Length;
import iso.std.iso._20022.tech.xsd.PersonIdentificationType1Code;
import jakarta.validation.Valid;
import java.io.Serializable;
import java.util.Date;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.joda.time.DateTime;

@Deprecated
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/v1_0/common", name="voucherdatatype", propOrder={"token", "identificationType", "identification", "money", "sourceFri", "status", "firstName", "surName", "externalId", "dateOfBirth", "creationDateTime", "expireDateTime", "reason"})
public class VoucherData
implements Serializable {
    private static final long serialVersionUID = 1L;
    @IsSecretString
    @SensitiveValue
    @XmlElement(name="token")
    private String token;
    @XmlElement(name="identificationtype")
    private PersonIdentificationType1Code identificationType;
    @IsMultiWordString
    @XmlElement(name="identification")
    private String identification;
    @XmlElement(name="money", type=MoneyDetails.class)
    @Valid
    @IsPositiveAmount
    private MoneyDetails money;
    @IsFinancialResourceIdentifier
    @XmlElement(name="sourcefri")
    private String sourceFri;
    @XmlElement(name="status")
    private VoucherStatus status;
    @IsFirstname
    @XmlElement(name="firstname")
    private String firstName;
    @IsSurname
    @XmlElement(name="surname")
    private String surName;
    @IsMultiWordString
    @XmlElement(name="externalid")
    private String externalId;
    @IsMultiWordString
    @XmlElement(name="dateofbirth")
    private String dateOfBirth;
    @XmlElement(name="creationdatetime")
    @XmlSchemaType(name="dateTime")
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    private Date creationDateTime;
    @XmlElement(name="expireDateTime")
    @XmlSchemaType(name="dateTime")
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    private Date expireDateTime;
    @IsMultilineRestrictedString
    @Length(max=128)
    @XmlElement(name="reason")
    private String reason;

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public PersonIdentificationType1Code getIdentificationType() {
        return this.identificationType;
    }

    public void setIdentificationType(PersonIdentificationType1Code identificationType) {
        this.identificationType = identificationType;
    }

    public String getIdentification() {
        return this.identification;
    }

    public void setIdentification(String identification) {
        this.identification = identification;
    }

    public MoneyDetails getMoney() {
        return this.money;
    }

    public void setMoney(MoneyDetails money) {
        this.money = money;
    }

    public String getSourceFri() {
        return this.sourceFri;
    }

    public void setSourceFri(String sourceFri) {
        this.sourceFri = sourceFri;
    }

    public VoucherStatus getStatus() {
        return this.status;
    }

    public void setStatus(VoucherStatus status) {
        this.status = status;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getSurName() {
        return this.surName;
    }

    public void setSurName(String surName) {
        this.surName = surName;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public String getDateOfBirth() {
        return this.dateOfBirth;
    }

    public void setDateOfBirth(String dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public DateTime getCreationDateTime() {
        return DateHelper.fromDate(this.creationDateTime);
    }

    public void setCreationDateTime(DateTime creationDateTime) {
        this.creationDateTime = DateHelper.toDate(creationDateTime);
    }

    public DateTime getExpireDateTime() {
        return DateHelper.fromDate(this.expireDateTime);
    }

    public void setExpireDateTime(DateTime expireDateTime) {
        this.expireDateTime = DateHelper.toDate(expireDateTime);
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }
}

