/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.v1_0.common;

import com.ericsson.em.m3if.operations.utils.DateHelper;
import com.ericsson.em.m3if.v1_0.common.Frequency;
import com.ericsson.em.m3if.v1_0.common.RecurringInfo;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.base.AbstractInstant;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/v1_0/common", name="scheduledtransactiondate", propOrder={"date", "recurringInfo"})
@Deprecated
public class ScheduledTransactionDate
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlSchemaType(name="date")
    @XmlElement(name="date", required=true)
    @NotNull
    private Date date;
    @Valid
    @XmlElement(name="recurringinfo", type=RecurringInfo.class)
    private RecurringInfo recurringInfo;

    public ScheduledTransactionDate() {
    }

    public ScheduledTransactionDate(DateTime date) {
        this.date = DateHelper.toDate(date);
    }

    public ScheduledTransactionDate(LocalDate date) {
        this.date = date == null ? null : date.toDateMidnight().toDate();
    }

    public ScheduledTransactionDate(LocalDate date, Frequency frequency, Integer frequencyValue) {
        this.date = date == null ? null : date.toDateMidnight().toDate();
        this.recurringInfo = new RecurringInfo(frequency, frequencyValue);
    }

    public LocalDate getLocalDate() {
        return DateHelper.dateMidnightFromDate(this.date).toLocalDate();
    }

    public AbstractInstant getDate() {
        return DateHelper.dateMidnightFromDate(this.date);
    }

    public void setDate(AbstractInstant date) {
        this.date = DateHelper.toDate(date);
    }

    public RecurringInfo getRecurringInfo() {
        return this.recurringInfo;
    }

    public void setRecurringInfo(RecurringInfo recurringInfo) {
        this.recurringInfo = recurringInfo;
    }
}

