/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.v1_0.common;

import com.ericsson.em.m3if.v1_0.common.IndexOffset;
import com.ericsson.em.m3if.v1_0.common.MaximumNumberOfEntries;
import com.ericsson.em.m3if.v1_0.common.Paging;
import com.ericsson.em.m3if.v1_0.common.TimedPagingInfo;
import com.ericsson.em.validation.Validation;
import jakarta.validation.Valid;
import java.io.Serializable;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/v1_0/common", name="paginginfo", propOrder={"maximumNumberOfItems", "indexOffset"})
public class PagingInfo
implements Serializable,
Paging {
    private static final long serialVersionUID = -1300184451692128027L;
    static final MaximumNumberOfEntries DEFAULT_MAXIMUM_NUMBER_OF_ITEMS = MaximumNumberOfEntries.fromInteger(50);
    static final IndexOffset DEFAULT_INDEX_OFFSET = IndexOffset.fromInteger(0);
    @Valid
    @XmlElement(name="maximumnumberofitems", defaultValue="50")
    private final MaximumNumberOfEntries maximumNumberOfItems;
    @Valid
    @XmlElement(name="indexoffset", defaultValue="0")
    private final IndexOffset indexOffset;

    protected PagingInfo() {
        this.maximumNumberOfItems = DEFAULT_MAXIMUM_NUMBER_OF_ITEMS;
        this.indexOffset = DEFAULT_INDEX_OFFSET;
    }

    protected PagingInfo(MaximumNumberOfEntries maximumNumberOfItems, IndexOffset indexOffset) {
        this.maximumNumberOfItems = maximumNumberOfItems;
        this.indexOffset = indexOffset;
    }

    @Override
    public MaximumNumberOfEntries getMaximumNumberOfItems() {
        return this.maximumNumberOfItems;
    }

    @Override
    public IndexOffset getIndexOffset() {
        return this.indexOffset;
    }

    public static PagingInfo fromDefaultValues() {
        return PagingInfo.from(DEFAULT_MAXIMUM_NUMBER_OF_ITEMS, DEFAULT_INDEX_OFFSET);
    }

    public static PagingInfo from(MaximumNumberOfEntries maximumNumberOfItems) {
        return PagingInfo.from(maximumNumberOfItems, DEFAULT_INDEX_OFFSET);
    }

    public static PagingInfo from(IndexOffset indexOffset) {
        return PagingInfo.from(DEFAULT_MAXIMUM_NUMBER_OF_ITEMS, indexOffset);
    }

    public static PagingInfo from(MaximumNumberOfEntries maximumNumberOfItems, IndexOffset indexOffset) {
        return Validation.validate(new PagingInfo(maximumNumberOfItems, indexOffset));
    }

    public static TimedPagingInfo fromPaging(Paging paging) {
        return new TimedPagingInfo(paging.getMaximumNumberOfItems(), paging.getIndexOffset());
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null || this.getClass() != otherObject.getClass()) {
            return false;
        }
        PagingInfo that = (PagingInfo)otherObject;
        return Objects.equals(this.maximumNumberOfItems, that.maximumNumberOfItems) && Objects.equals(this.indexOffset, that.indexOffset);
    }

    public int hashCode() {
        return Objects.hash(this.maximumNumberOfItems, this.indexOffset);
    }
}

