/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.v1_0.common;

import com.ericsson.em.validators.IsMSISDN;
import com.ericsson.em.validators.Length;
import com.ericsson.em.validators.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/v1_0/common", name="msisdn")
public class MsisdnValue
implements Comparable<MsisdnValue>,
Serializable {
    private static final long serialVersionUID = 1L;
    @IsMSISDN
    @Length(max=16)
    @NotNull
    @NotBlank
    @XmlValue
    private final String value;

    protected MsisdnValue() {
        this.value = null;
    }

    private MsisdnValue(String msisdn) {
        this.value = msisdn;
    }

    public static MsisdnValue fromString(String value) {
        if (value == null) {
            return null;
        }
        return new MsisdnValue(value);
    }

    public String getValueAsString() {
        return this.value;
    }

    public static Optional<String> asString(MsisdnValue msisdn) {
        if (msisdn == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(msisdn.getValueAsString());
    }

    public String toString() {
        return this.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MsisdnValue other = (MsisdnValue)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    @Override
    public int compareTo(MsisdnValue o) {
        return this.value.compareTo(o.value);
    }
}

