/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.v1_0.common;

import com.ericsson.em.emm.util.ValueObject;
import com.ericsson.em.m3if.v1_0.common.Iso8601DateTime;
import com.ericsson.em.validators.IsDateString;
import com.ericsson.em.validators.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDate;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/v1_0/common", name="iso8601date")
public final class Iso8601Date
implements ValueObject,
Comparable<Iso8601Date>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final DateTimeFormatter JODA_FORMATTER = DateTimeFormat.forPattern(IsDateString.DATE_FORMAT.ISO.getFormat());
    private static final java.time.format.DateTimeFormatter JAVA_FORMATTER = java.time.format.DateTimeFormatter.ISO_LOCAL_DATE;
    @IsDateString(format=IsDateString.DATE_FORMAT.ISO, minDate="1890-01-01")
    @NotNull
    @NotBlank
    @XmlValue
    private final String value;

    protected Iso8601Date() {
        this.value = null;
    }

    private Iso8601Date(String value) {
        this.value = value;
    }

    private Iso8601Date(org.joda.time.LocalDate value) {
        this.value = JODA_FORMATTER.print(value);
    }

    private Iso8601Date(LocalDate value) {
        this.value = value.format(JAVA_FORMATTER);
    }

    public static Iso8601Date fromString(String value) {
        if (value == null) {
            return null;
        }
        return new Iso8601Date(value);
    }

    public static Iso8601Date fromLocalDate(org.joda.time.LocalDate value) {
        if (value == null) {
            return null;
        }
        return new Iso8601Date(value);
    }

    public static Iso8601Date fromLocalDate(LocalDate value) {
        if (value == null) {
            return null;
        }
        return new Iso8601Date(value);
    }

    public static Iso8601Date fromDateTime(DateTime date) {
        Iso8601DateTime iso8601DateTime = Iso8601DateTime.fromDateTime(date);
        if (iso8601DateTime != null) {
            return Iso8601Date.fromLocalDate(iso8601DateTime.getValueAsZonedDateTime().toLocalDate());
        }
        return null;
    }

    public static Iso8601Date now() {
        return Iso8601Date.fromLocalDate(LocalDate.now());
    }

    @Override
    public String getValueAsString() {
        return this.value;
    }

    public LocalDate getValueAsLocalDate() {
        return LocalDate.parse(this.value, JAVA_FORMATTER);
    }

    public String toString() {
        return this.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Iso8601Date other = (Iso8601Date)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    @Override
    public int compareTo(Iso8601Date o) {
        return this.value.compareTo(o.value);
    }
}

