/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.v1_0.common;

import com.ericsson.em.m3if.operations.adapter.DateAdapter;
import com.ericsson.em.m3if.operations.utils.DateHelper;
import com.ericsson.em.m3if.operations.validation.IsPositiveAmount;
import com.ericsson.em.m3if.v1_0.common.FinancialTransactionStatus;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.m3if.v1_0.common.TransferType;
import com.ericsson.em.validators.IsExternalTransactionIdString;
import com.ericsson.em.validators.IsFinancialResourceIdentifier;
import com.ericsson.em.validators.IsIdentity;
import com.ericsson.em.validators.IsNumericString;
import com.ericsson.em.validators.IsRestrictedString;
import com.ericsson.em.validators.IsUsername;
import jakarta.validation.Valid;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.joda.time.DateTime;

@Deprecated
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/v1_0/common", name="gettransactionhistoryentrytype", propOrder={"financialTransactionId", "transactionStatus", "transferType", "startDate", "commitDate", "fxRate", "initiatingUser", "realUser", "initiatingAccountHolder", "realAccountHolder", "from", "fromAccount", "fromAmount", "fromFee", "fromExternalFee", "fromDiscount", "fromPromotion", "fromLoyFee", "fromLoyReward", "fromPromotionRefund", "fromNote", "fromAvailableBalance", "fromTotalBalance", "fromCommittedBalance", "fromAccountHolder", "to", "toAccount", "toAmount", "toFee", "toExternalFee", "toPromotion", "toLoyFee", "toLoyReward", "toPromotionRefund", "toDiscountRefund", "toMessage", "toAvailableBalance", "toTotalBalance", "toCommittedBalance", "mainInstructionId", "instructionId", "externalTransactionId", "transactionText", "toFeeRefund", "fromFeeRefund", "toAccountHolder"})
public class GetTransactionHistoryEntry
implements Serializable {
    private static final long serialVersionUID = 1L;
    @IsNumericString
    @XmlElement(name="financialtransactionid")
    private String financialTransactionId = null;
    @XmlElement(name="transactionstatus")
    private FinancialTransactionStatus transactionStatus;
    @XmlElement(name="transfertype")
    private TransferType transferType;
    @XmlElement(name="startdate")
    @XmlSchemaType(name="dateTime")
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    private Date startDate;
    @XmlElement(name="commitdate")
    @XmlSchemaType(name="dateTime")
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    private Date commitDate;
    @XmlElement(name="fxrate")
    private BigDecimal fxRate;
    @IsUsername
    @XmlElement(name="initiatinguser")
    private String initiatingUser;
    @IsUsername
    @XmlElement(name="realuser")
    private String realUser;
    @IsIdentity
    @XmlElement(name="initiatingaccountholder")
    private String initiatingAccountHolder;
    @IsIdentity
    @XmlElement(name="realaccountholder")
    private String realAccountHolder;
    @IsFinancialResourceIdentifier
    @XmlElement(name="from")
    private String from;
    @IsFinancialResourceIdentifier
    @XmlElement(name="fromaccount")
    private String fromAccount;
    @Valid
    @XmlElement(name="fromamount")
    @IsPositiveAmount
    private MoneyDetails fromAmount;
    @Valid
    @XmlElement(name="fromfee")
    @IsPositiveAmount
    private MoneyDetails fromFee;
    @Valid
    @XmlElement(name="fromexternalfee")
    @IsPositiveAmount
    private MoneyDetails fromExternalFee;
    @Valid
    @XmlElement(name="fromdiscount")
    @IsPositiveAmount
    private MoneyDetails fromDiscount;
    @Valid
    @XmlElement(name="frompromotion")
    @IsPositiveAmount
    private MoneyDetails fromPromotion;
    @XmlElement(name="fromloyfee")
    private BigDecimal fromLoyFee;
    @XmlElement(name="fromloyreward")
    private BigDecimal fromLoyReward;
    @IsRestrictedString
    @XmlElement(name="fromnote")
    private String fromNote;
    @Valid
    @XmlElement(name="fromavailablebalance")
    @IsPositiveAmount
    private MoneyDetails fromAvailableBalance;
    @Valid
    @XmlElement(name="fromtotalbalance")
    @IsPositiveAmount
    private MoneyDetails fromTotalBalance;
    @XmlElement(name="fromcommittedbalance")
    @Valid
    @IsPositiveAmount
    private MoneyDetails fromCommittedBalance;
    @IsIdentity
    @XmlElement(name="fromaccountholder")
    private String fromAccountHolder;
    @IsFinancialResourceIdentifier
    @XmlElement(name="to")
    private String to;
    @IsFinancialResourceIdentifier
    @XmlElement(name="toaccount")
    private String toAccount;
    @Valid
    @XmlElement(name="toamount")
    @IsPositiveAmount
    private MoneyDetails toAmount;
    @Valid
    @XmlElement(name="tofee")
    @IsPositiveAmount
    private MoneyDetails toFee;
    @Valid
    @XmlElement(name="toexternalfee")
    @IsPositiveAmount
    private MoneyDetails toExternalFee;
    @Valid
    @XmlElement(name="topromotion")
    @IsPositiveAmount
    private MoneyDetails toPromotion;
    @XmlElement(name="toloyfee")
    private BigDecimal toLoyFee;
    @XmlElement(name="toloyreward")
    private BigDecimal toLoyReward;
    @IsRestrictedString
    @XmlElement(name="tomessage")
    private String toMessage;
    @XmlElement(name="toavailablebalance")
    @Valid
    @IsPositiveAmount
    private MoneyDetails toAvailableBalance;
    @XmlElement(name="tocommittedbalance")
    @Valid
    @IsPositiveAmount
    private MoneyDetails toCommittedBalance;
    @XmlElement(name="instructionid")
    private Long instructionId;
    @XmlElement(name="maininstructionid")
    private Long mainInstructionId;
    @IsExternalTransactionIdString
    @XmlElement(name="externaltransactionid")
    private String externalTransactionId;
    @IsRestrictedString
    @XmlElement(name="transactiontext")
    private String transactionText;
    @XmlElement(name="tototalbalance")
    @Valid
    @IsPositiveAmount
    private MoneyDetails toTotalBalance;
    @XmlElement(name="tofeerefund")
    @Valid
    @IsPositiveAmount
    private MoneyDetails toFeeRefund;
    @XmlElement(name="fromfeerefund")
    @Valid
    @IsPositiveAmount
    private MoneyDetails fromFeeRefund;
    @XmlElement(name="frompromotionrefund")
    @Valid
    @IsPositiveAmount
    private MoneyDetails fromPromotionRefund;
    @XmlElement(name="topromotionrefund")
    @Valid
    @IsPositiveAmount
    private MoneyDetails toPromotionRefund;
    @XmlElement(name="todiscountrefund")
    @Valid
    @IsPositiveAmount
    private MoneyDetails toDiscountRefund;
    @IsIdentity
    @XmlElement(name="toaccountholder")
    private String toAccountHolder;

    public String getFinancialTransactionId() {
        return this.financialTransactionId;
    }

    public void setFinancialTransactionId(String financialTransactionId) {
        this.financialTransactionId = financialTransactionId;
    }

    public FinancialTransactionStatus getTransactionStatus() {
        return this.transactionStatus;
    }

    public void setTransactionStatus(FinancialTransactionStatus transactionStatus) {
        this.transactionStatus = transactionStatus;
    }

    public DateTime getStartDate() {
        return DateHelper.fromDate(this.startDate);
    }

    public void setStartDate(DateTime startDate) {
        this.startDate = DateHelper.toDate(startDate);
    }

    public MoneyDetails getFromAmount() {
        return this.fromAmount;
    }

    public void setFromAmount(MoneyDetails fromAmount) {
        this.fromAmount = fromAmount;
    }

    public MoneyDetails getFromFee() {
        return this.fromFee;
    }

    public void setFromFee(MoneyDetails fromFee) {
        this.fromFee = fromFee;
    }

    public MoneyDetails getFromExternalFee() {
        return this.fromExternalFee;
    }

    public void setFromExternalFee(MoneyDetails fromExternalFee) {
        this.fromExternalFee = fromExternalFee;
    }

    public MoneyDetails getFromDiscount() {
        return this.fromDiscount;
    }

    public void setFromDiscount(MoneyDetails fromDiscount) {
        this.fromDiscount = fromDiscount;
    }

    public MoneyDetails getFromPromotion() {
        return this.fromPromotion;
    }

    public void setFromPromotion(MoneyDetails fromPromotion) {
        this.fromPromotion = fromPromotion;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String source) {
        this.from = source;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String target) {
        this.to = target;
    }

    public String getFromNote() {
        return this.fromNote;
    }

    public void setFromNote(String fromNote) {
        this.fromNote = fromNote;
    }

    public MoneyDetails getFromAvailableBalance() {
        return this.fromAvailableBalance;
    }

    public void setFromAvailableBalance(MoneyDetails fromAvailableBalance) {
        this.fromAvailableBalance = fromAvailableBalance;
    }

    public MoneyDetails getFromTotalBalance() {
        return this.fromTotalBalance;
    }

    public void setFromTotalBalance(MoneyDetails fromTotalBalance) {
        this.fromTotalBalance = fromTotalBalance;
    }

    public MoneyDetails getFromCommittedBalance() {
        return this.fromCommittedBalance;
    }

    public void setFromCommittedBalance(MoneyDetails fromCommittedBalance) {
        this.fromCommittedBalance = fromCommittedBalance;
    }

    public void setToAmount(MoneyDetails targetAmount) {
        this.toAmount = targetAmount;
    }

    public MoneyDetails getToAmount() {
        return this.toAmount;
    }

    public void setFxRate(BigDecimal fxRate) {
        this.fxRate = fxRate;
    }

    public BigDecimal getFxRate() {
        return this.fxRate;
    }

    public void setTransferType(TransferType transferType) {
        this.transferType = transferType;
    }

    public TransferType getTransferType() {
        return this.transferType;
    }

    public BigDecimal getFromLoyFee() {
        return this.fromLoyFee;
    }

    public void setFromLoyFee(BigDecimal fromLoyFee) {
        this.fromLoyFee = fromLoyFee;
    }

    public BigDecimal getFromLoyReward() {
        return this.fromLoyReward;
    }

    public void setFromLoyReward(BigDecimal fromLoyReward) {
        this.fromLoyReward = fromLoyReward;
    }

    public MoneyDetails getToFee() {
        return this.toFee;
    }

    public void setToFee(MoneyDetails receiverFee) {
        this.toFee = receiverFee;
    }

    public MoneyDetails getToExternalFee() {
        return this.toExternalFee;
    }

    public void setToExternalFee(MoneyDetails toExternalFee) {
        this.toExternalFee = toExternalFee;
    }

    public MoneyDetails getToPromotion() {
        return this.toPromotion;
    }

    public void setToPromotion(MoneyDetails toPromotion) {
        this.toPromotion = toPromotion;
    }

    public BigDecimal getToLoyFee() {
        return this.toLoyFee;
    }

    public void setToLoyFee(BigDecimal receiverLoyFee) {
        this.toLoyFee = receiverLoyFee;
    }

    public BigDecimal getToLoyReward() {
        return this.toLoyReward;
    }

    public void setToLoyReward(BigDecimal receiverLoyReward) {
        this.toLoyReward = receiverLoyReward;
    }

    public String getToMessage() {
        return this.toMessage;
    }

    public void setToMessage(String receiverMessage) {
        this.toMessage = receiverMessage;
    }

    public MoneyDetails getToAvailableBalance() {
        return this.toAvailableBalance;
    }

    public void setToAvailableBalance(MoneyDetails receiverBalance) {
        this.toAvailableBalance = receiverBalance;
    }

    public MoneyDetails getToTotalBalance() {
        return this.toTotalBalance;
    }

    public void setToTotalBalance(MoneyDetails toTotalBalance) {
        this.toTotalBalance = toTotalBalance;
    }

    public MoneyDetails getToCommittedBalance() {
        return this.toCommittedBalance;
    }

    public void setToCommittedBalance(MoneyDetails toCommittedBalance) {
        this.toCommittedBalance = toCommittedBalance;
    }

    public String getFromAccount() {
        return this.fromAccount;
    }

    public void setFromAccount(String fromAccount) {
        this.fromAccount = fromAccount;
    }

    public String getToAccount() {
        return this.toAccount;
    }

    public void setToAccount(String toAccount) {
        this.toAccount = toAccount;
    }

    public String getInitiatingUser() {
        return this.initiatingUser;
    }

    public void setInitiatingUser(String initiatingUser) {
        this.initiatingUser = initiatingUser;
    }

    public String getRealUser() {
        return this.realUser;
    }

    public void setRealUser(String real) {
        this.realUser = real;
    }

    public String getInitiatingAccountHolder() {
        return this.initiatingAccountHolder;
    }

    public void setInitiatingAccountHolder(String initiatingAccountHolder) {
        this.initiatingAccountHolder = initiatingAccountHolder;
    }

    public String getRealAccountHolder() {
        return this.realAccountHolder;
    }

    public void setRealAccountHolder(String realAccountHolder) {
        this.realAccountHolder = realAccountHolder;
    }

    public DateTime getCommitDate() {
        return DateHelper.fromDate(this.commitDate);
    }

    public void setCommitDate(DateTime commitDate) {
        this.commitDate = DateHelper.toDate(commitDate);
    }

    public Long getMainInstructionId() {
        return this.mainInstructionId;
    }

    public void setMainInstructionId(Long mainInstructionId) {
        this.mainInstructionId = mainInstructionId;
    }

    public Long getInstructionId() {
        return this.instructionId;
    }

    public void setInstructionId(Long instructionId) {
        this.instructionId = instructionId;
    }

    public String getExternalTransactionId() {
        return this.externalTransactionId;
    }

    public void setExternalTransactionId(String externalTransactionId) {
        this.externalTransactionId = externalTransactionId;
    }

    public String getTransactionText() {
        return this.transactionText;
    }

    public void setTransactionText(String transactionText) {
        this.transactionText = transactionText;
    }

    public void setToFeeRefund(MoneyDetails toFeeRefund) {
        this.toFeeRefund = toFeeRefund;
    }

    public MoneyDetails getToFeeRefund() {
        return this.toFeeRefund;
    }

    public void setFromFeeRefund(MoneyDetails fromFeeRefund) {
        this.fromFeeRefund = fromFeeRefund;
    }

    public MoneyDetails getFromFeeRefund() {
        return this.fromFeeRefund;
    }

    public MoneyDetails getFromPromotionRefund() {
        return this.fromPromotionRefund;
    }

    public void setFromPromotionRefund(MoneyDetails fromPromotionRefund) {
        this.fromPromotionRefund = fromPromotionRefund;
    }

    public MoneyDetails getToPromotionRefund() {
        return this.toPromotionRefund;
    }

    public void setToPromotionRefund(MoneyDetails toPromotionRefund) {
        this.toPromotionRefund = toPromotionRefund;
    }

    public MoneyDetails getToDiscountRefund() {
        return this.toDiscountRefund;
    }

    public void setToDiscountRefund(MoneyDetails toDiscountRefund) {
        this.toDiscountRefund = toDiscountRefund;
    }

    public String getFromAccountHolder() {
        return this.fromAccountHolder;
    }

    public void setFromAccountHolder(String fromAccountHolder) {
        this.fromAccountHolder = fromAccountHolder;
    }

    public String getToAccountHolder() {
        return this.toAccountHolder;
    }

    public void setToAccountHolder(String toAccountHolder) {
        this.toAccountHolder = toAccountHolder;
    }
}

