/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.v1_0.common;

import com.ericsson.em.emm.util.ValueObject;
import com.ericsson.em.validators.IsInteger;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/v1_0/common", name="expiresin")
public class ExpiresIn
implements Comparable<ExpiresIn>,
Serializable,
ValueObject {
    private static final long serialVersionUID = 1L;
    @NotNull
    @Min(value=0L)
    @Max(value=3600L)
    @IsInteger
    @XmlValue
    private final @NotNull @Min(value=0L) @Max(value=3600L) String value;

    protected ExpiresIn() {
        this.value = null;
    }

    private ExpiresIn(String value) {
        this.value = value;
    }

    private ExpiresIn(int value) {
        this.value = String.valueOf(value);
    }

    private ExpiresIn(long value) {
        this.value = String.valueOf(value);
    }

    public static ExpiresIn fromString(String value) {
        if (value == null) {
            return null;
        }
        return new ExpiresIn(Integer.parseInt(value));
    }

    public static ExpiresIn fromInt(Integer value) {
        if (value == null) {
            return null;
        }
        return new ExpiresIn(value);
    }

    public static ExpiresIn fromLong(Long value) {
        if (value == null) {
            return null;
        }
        return new ExpiresIn(value);
    }

    @Override
    public String getValueAsString() {
        return this.value;
    }

    public Long getValueAsLong() {
        return Long.parseLong(this.value);
    }

    public static Optional<String> asString(ExpiresIn value) {
        if (value == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(value.getValueAsString());
    }

    public String toString() {
        return this.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExpiresIn other = (ExpiresIn)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    @Override
    public int compareTo(ExpiresIn o) {
        return this.value.compareTo(o.value);
    }
}

