/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.v1_0.common;

import com.ericsson.em.m3if.v1_0.common.TimeUnitType;
import com.ericsson.em.validators.IsPositiveLong;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/v1_0/common", name="duration", propOrder={"time", "unit"})
public final class Duration
implements Serializable {
    private static final long serialVersionUID = -1491707222481436316L;
    @IsPositiveLong(allowNull=false, allowZero=true)
    @XmlElement(name="time", required=true)
    private final Long time;
    @Valid
    @NotNull
    @XmlElement(name="unit", required=true, defaultValue="SECONDS")
    private final TimeUnitType unit;

    Duration() {
        this.time = null;
        this.unit = TimeUnitType.SECONDS;
    }

    private Duration(Long time, TimeUnitType unit) {
        this.time = time;
        this.unit = unit;
    }

    public static Duration from(java.time.Duration javaDuration) {
        return Duration.from(javaDuration.get(ChronoUnit.SECONDS), TimeUnitType.SECONDS);
    }

    public static Duration from(Long time, TimeUnitType unit) {
        return new Duration(time, unit);
    }

    public Long getTime() {
        return this.time;
    }

    public TimeUnitType getUnit() {
        return this.unit;
    }

    public java.time.Duration asJavaDuration() {
        ZonedDateTime now = ZonedDateTime.now();
        return java.time.Duration.between(now, now.plus(this.time, this.unit.asChronoUnit()));
    }

    public String toString() {
        return String.format("%d %s", new Object[]{this.time, this.unit});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Duration that = (Duration)o;
        return this.time != null && this.time.equals(that.time) && this.unit.equals((Object)that.unit);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.time, this.unit});
    }
}

