/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.v1_0.common;

import com.ericsson.em.m3if.v1_0.common.ExternalDocumentId;
import com.ericsson.em.m3if.v1_0.common.ExternalTextValue;
import com.ericsson.em.m3if.v1_0.common.FileNameValue;
import com.ericsson.em.m3if.v1_0.common.Iso8601DateTime;
import com.ericsson.em.m3if.v1_0.common.LongDescriptionValue;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.joda.time.DateTime;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/v1_0/common", name="documentreferenceinformation", propOrder={"externalDocumentId", "filename", "documentNumber", "description", "uploadDateTime"})
public class DocumentReferenceInformation
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Valid
    @NotNull
    @XmlElement(name="externaldocumentid", type=ExternalDocumentId.class, required=true)
    private ExternalDocumentId externalDocumentId;
    @NotNull
    @Valid
    @XmlElement(name="filename", type=FileNameValue.class, required=true)
    private FileNameValue filename;
    @NotNull
    @Valid
    @XmlElement(name="documentnumber", type=ExternalTextValue.class, required=true)
    private ExternalTextValue documentNumber;
    @Valid
    @XmlElement(name="description", type=LongDescriptionValue.class)
    private LongDescriptionValue description;
    @Valid
    @NotNull
    @XmlElement(name="uploaddatetime", type=Iso8601DateTime.class, required=true)
    private Iso8601DateTime uploadDateTime;

    protected DocumentReferenceInformation() {
    }

    private DocumentReferenceInformation(Builder builder) {
        this.externalDocumentId = builder.externalDocumentId;
        this.filename = builder.filename;
        this.documentNumber = builder.documentNumber;
        this.description = builder.description;
        this.uploadDateTime = builder.uploadDateTime;
    }

    public ExternalDocumentId getExternalDocumentId() {
        return this.externalDocumentId;
    }

    public void setExternalDocumentId(ExternalDocumentId externalDocumentId) {
        this.externalDocumentId = externalDocumentId;
    }

    public FileNameValue getFilename() {
        return this.filename;
    }

    public void setFilename(FileNameValue filename) {
        this.filename = filename;
    }

    public ExternalTextValue getDocumentNumber() {
        return this.documentNumber;
    }

    public void setDocumentNumber(ExternalTextValue documentNumber) {
        this.documentNumber = documentNumber;
    }

    public LongDescriptionValue getDescription() {
        return this.description;
    }

    public void setDescription(LongDescriptionValue description) {
        this.description = description;
    }

    public Iso8601DateTime getUploadDateTime() {
        return this.uploadDateTime;
    }

    public void setUploadDateTime(Iso8601DateTime uploadDateTime) {
        this.uploadDateTime = uploadDateTime;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private ExternalDocumentId externalDocumentId;
        private FileNameValue filename;
        private ExternalTextValue documentNumber;
        private LongDescriptionValue description;
        private Iso8601DateTime uploadDateTime;

        public Builder externalDocumentId(String externalDocumentId) {
            this.externalDocumentId = ExternalDocumentId.fromString(externalDocumentId);
            return this;
        }

        public Builder filename(String filename) {
            this.filename = FileNameValue.fromString(filename);
            return this;
        }

        public Builder documentNumber(String documentNumber) {
            this.documentNumber = ExternalTextValue.fromString(documentNumber);
            return this;
        }

        public Builder description(String description) {
            this.description = LongDescriptionValue.fromString(description);
            return this;
        }

        public Builder uploadDateTime(DateTime uploadDateTime) {
            this.uploadDateTime = Iso8601DateTime.fromDateTime(uploadDateTime);
            return this;
        }

        public DocumentReferenceInformation build() {
            return new DocumentReferenceInformation(this);
        }
    }
}

