/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.v1_0.common;

import com.ericsson.em.emm.util.ValueObject;
import com.ericsson.em.validation.Validation;
import com.ericsson.em.validators.IsBase64Encoded;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.io.Serializable;
import java.util.Base64;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/v1_0/common", name="base64")
public final class Base64Value
implements Serializable,
ValueObject {
    private static final long serialVersionUID = 1L;
    @XmlValue
    @NotNull
    @IsBase64Encoded
    @Size(max=0x200000)
    private final @NotNull @Size(max=0x200000) String value;

    private Base64Value() {
        this.value = "";
    }

    private Base64Value(String value) {
        this.value = value;
    }

    public static Base64Value fromEncodedString(String value) {
        if (value == null) {
            return null;
        }
        return Validation.validate(new Base64Value(value));
    }

    public static Base64Value fromString(String value) {
        if (value == null) {
            return null;
        }
        String encodedString = Base64.getEncoder().encodeToString(value.getBytes());
        return Validation.validate(new Base64Value(encodedString));
    }

    public static Base64Value fromByteArray(byte[] value) {
        if (value == null) {
            return null;
        }
        return Validation.validate(new Base64Value(new String(value)));
    }

    @Override
    public String getValueAsString() {
        return this.value;
    }

    public String getDecodedString() {
        return new String(Base64.getDecoder().decode(this.value));
    }

    public byte[] getValueAsByteArray() {
        return this.value.getBytes();
    }

    public String toString() {
        return this.value;
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Base64Value other = (Base64Value)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

