/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.settlement.v1_0.common;

import com.ericsson.em.m3if.operations.adapter.DateAdapter;
import com.ericsson.em.m3if.operations.utils.DateHelper;
import com.ericsson.em.m3if.operations.validation.IsPositiveAmount;
import com.ericsson.em.m3if.settlement.v1_0.common.BankInstructionType;
import com.ericsson.em.m3if.settlement.v1_0.common.PaymentInstructionStatus;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.validators.IsBankAccount;
import com.ericsson.em.validators.IsBankCode;
import com.ericsson.em.validators.IsEnum;
import com.ericsson.em.validators.IsExternalTransactionIdString;
import com.ericsson.em.validators.IsFinancialResourceIdentifier;
import com.ericsson.em.validators.IsIdentity;
import com.ericsson.em.validators.IsMultiWordString;
import com.ericsson.em.validators.IsPositiveLong;
import com.ericsson.em.validators.NotBlank;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.joda.time.DateTime;

@Deprecated
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/settlement/v1_0/common", name="bankinstructiondetails", propOrder={"financialTransactionId", "identity", "bankInstructionId", "externalTransactionId", "callerIdentifier", "custodyAccountClearingNumber", "custodyAccountNumber", "timestamp", "amount", "status", "accountHolderClearingNumber", "accountHolderAccountNumber", "fri", "lastUpdatedTimeStamp", "bankInstructionType"})
public class BankInstructionDetails
implements Serializable {
    private static final long serialVersionUID = 1L;
    @IsPositiveLong(allowZero=false)
    @XmlElement(name="financialtransaction")
    private Long financialTransactionId;
    @IsIdentity
    @XmlElement(name="identity")
    private String identity;
    @IsPositiveLong(allowZero=false)
    @XmlElement(name="bankinstructionid")
    private Long bankInstructionId;
    @IsExternalTransactionIdString
    @XmlElement(name="externaltransactionid")
    private String externalTransactionId;
    @IsMultiWordString
    @XmlElement(name="calleridentifier")
    private String callerIdentifier;
    @XmlElement(name="timestamp")
    @XmlSchemaType(name="dateTime")
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    private Date timestamp;
    @IsBankCode
    @XmlElement(name="custodyaccountclearingnumber")
    private String custodyAccountClearingNumber;
    @IsBankAccount
    @XmlElement(name="custodyaccountnumber", required=true)
    @NotNull
    private String custodyAccountNumber;
    @Valid
    @XmlElement(name="amount")
    @IsPositiveAmount
    private MoneyDetails amount;
    @XmlElement(name="status", required=true)
    @NotNull
    private PaymentInstructionStatus status;
    @IsBankCode
    @XmlElement(name="accountholderclearingnumber")
    private String accountHolderClearingNumber;
    @IsBankAccount
    @XmlElement(name="accountholderaccountnumber")
    private String accountHolderAccountNumber;
    @IsFinancialResourceIdentifier
    @XmlElement(name="fri")
    private String fri;
    @XmlElement(name="lastupdatetimestamp")
    @XmlSchemaType(name="dateTime")
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    private Date lastUpdatedTimeStamp;
    @IsEnum(type=BankInstructionType.class)
    @NotBlank
    @XmlElement(name="bankinstructiontype", required=true)
    private String bankInstructionType;

    public DateTime getLastUpdatedTimeStamp() {
        return DateHelper.fromDate(this.lastUpdatedTimeStamp);
    }

    public void setLastUpdatedTimeStamp(DateTime lastUpdateTimeStamp) {
        this.lastUpdatedTimeStamp = DateHelper.toDate(lastUpdateTimeStamp);
    }

    public MoneyDetails getAmount() {
        return this.amount;
    }

    public void setAmount(MoneyDetails amount) {
        this.amount = amount;
    }

    public PaymentInstructionStatus getStatus() {
        return this.status;
    }

    public void setStatus(PaymentInstructionStatus status) {
        this.status = status;
    }

    public Long getFinancialTransactionId() {
        return this.financialTransactionId;
    }

    public void setFinancialTransactionId(Long financialTransactionId) {
        this.financialTransactionId = financialTransactionId;
    }

    public String getIdentity() {
        return this.identity;
    }

    public void setIdentity(String identity) {
        this.identity = identity;
    }

    public String getExternalTransactionId() {
        return this.externalTransactionId;
    }

    public void setExternalTransactionId(String externalTransactionId) {
        this.externalTransactionId = externalTransactionId;
    }

    public String getCallerIdentifier() {
        return this.callerIdentifier;
    }

    public void setCallerIdentifier(String callerIdentifier) {
        this.callerIdentifier = callerIdentifier;
    }

    public DateTime getTimestamp() {
        return DateHelper.fromDate(this.timestamp);
    }

    public void setTimestamp(DateTime timestamp) {
        this.timestamp = DateHelper.toDate(timestamp);
    }

    public String getCustodyAccountClearingNumber() {
        return this.custodyAccountClearingNumber;
    }

    public void setCustodyAccountClearingNumber(String custodyAccountClearingNumber) {
        this.custodyAccountClearingNumber = custodyAccountClearingNumber;
    }

    public String getCustodyAccountNumber() {
        return this.custodyAccountNumber;
    }

    public void setCustodyAccountNumber(String custodyAccountNumber) {
        this.custodyAccountNumber = custodyAccountNumber;
    }

    public String getAccountHolderClearingNumber() {
        return this.accountHolderClearingNumber;
    }

    public void setAccountHolderClearingNumber(String accountHolderClearingNumber) {
        this.accountHolderClearingNumber = accountHolderClearingNumber;
    }

    public String getAccountHolderAccountNumber() {
        return this.accountHolderAccountNumber;
    }

    public void setAccountHolderAccountNumber(String accountHolderAccountNumber) {
        this.accountHolderAccountNumber = accountHolderAccountNumber;
    }

    public String getFri() {
        return this.fri;
    }

    public void setFri(String fri) {
        this.fri = fri;
    }

    public Long getBankInstructionId() {
        return this.bankInstructionId;
    }

    public void setBankInstructionId(Long bankInstructionId) {
        this.bankInstructionId = bankInstructionId;
    }

    public String getBankInstructionType() {
        return this.bankInstructionType;
    }

    public void setBankInstructionType(String bankInstructionType) {
        this.bankInstructionType = bankInstructionType;
    }
}

