/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.serviceprovider.v1_2.backend.sptransfer;

import com.ericsson.em.m3if.financial.v1_0.quotation.QuoteRequest;
import com.ericsson.em.m3if.operations.annotations.SignedElements;
import com.ericsson.em.m3if.operations.validation.IsPositiveAmount;
import com.ericsson.em.m3if.serviceprovider.v1_0.common.Name;
import com.ericsson.em.m3if.v1_0.common.ExtensionType;
import com.ericsson.em.m3if.v1_0.common.FRIValue;
import com.ericsson.em.m3if.v1_0.common.MessageValue;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.m3if.v1_0.common.ProviderTransactionIdValue;
import com.ericsson.em.m3if.v1_0.common.QuoteId;
import com.ericsson.em.m3if.v1_0.common.ReferenceIdValue;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(namespace="http://www.ericsson.com/em/emm/serviceprovider/v1_2/backend", name="sptransferrequest")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/serviceprovider/v1_2/backend", name="", propOrder={"sendingFRI", "receivingFRI", "amount", "providerTransactionId", "name", "senderNote", "receiverMessage", "referenceId", "extension", "quoteId"})
@SignedElements(value={"sendingfri", "receivingfri", "amount/amount", "amount/currency", "providertransactionid", "referenceid"})
public class SPTransferRequest
implements Serializable,
QuoteRequest {
    private static final long serialVersionUID = 1L;
    @Valid
    @XmlElement(name="sendingfri", type=FRIValue.class, required=false)
    private FRIValue sendingFRI;
    @Valid
    @NotNull
    @XmlElement(name="receivingfri", type=FRIValue.class, required=true)
    private FRIValue receivingFRI;
    @Valid
    @NotNull
    @XmlElement(name="amount", type=MoneyDetails.class, required=true)
    @IsPositiveAmount
    private MoneyDetails amount;
    @Valid
    @NotNull
    @XmlElement(name="providertransactionid", type=ProviderTransactionIdValue.class, required=true)
    private ProviderTransactionIdValue providerTransactionId;
    @Valid
    @XmlElement(name="name", type=Name.class, required=false)
    private Name name;
    @Valid
    @XmlElement(name="sendernote", type=MessageValue.class, required=false)
    private MessageValue senderNote;
    @Valid
    @XmlElement(name="receivermessage", type=MessageValue.class, required=false)
    private MessageValue receiverMessage;
    @Valid
    @XmlElement(name="referenceid", type=ReferenceIdValue.class, required=false)
    private ReferenceIdValue referenceId;
    @Valid
    @XmlElement(name="extension", type=ExtensionType.class, required=false)
    private ExtensionType extension;
    @Valid
    @XmlElement(name="quoteid", type=QuoteId.class, required=false)
    private QuoteId quoteId;

    public SPTransferRequest() {
    }

    public SPTransferRequest(FRIValue sendingFRI, FRIValue receivingFRI, MoneyDetails amount, ProviderTransactionIdValue providerTransactionId, ReferenceIdValue referenceId) {
        this.setSendingFRI(sendingFRI);
        this.setReceivingFRI(receivingFRI);
        this.setAmount(amount);
        this.setProviderTransactionId(providerTransactionId);
        this.setReferenceId(referenceId);
    }

    public SPTransferRequest(FRIValue sendingFRI, FRIValue receivingFRI, MoneyDetails amount, ProviderTransactionIdValue providerTransactionId, Name name, MessageValue senderNote, MessageValue receiverMessage, ReferenceIdValue referenceId) {
        this(sendingFRI, receivingFRI, amount, providerTransactionId, referenceId);
        this.setName(name);
        this.setSenderNote(senderNote);
        this.setReceiverMessage(receiverMessage);
    }

    public FRIValue getSendingFRI() {
        return this.sendingFRI;
    }

    public void setSendingFRI(FRIValue sendingFRI) {
        this.sendingFRI = sendingFRI;
    }

    public FRIValue getReceivingFRI() {
        return this.receivingFRI;
    }

    public void setReceivingFRI(FRIValue receivingFRI) {
        this.receivingFRI = receivingFRI;
    }

    public MoneyDetails getAmount() {
        return this.amount;
    }

    public void setAmount(MoneyDetails amount) {
        this.amount = amount;
    }

    public ProviderTransactionIdValue getProviderTransactionId() {
        return this.providerTransactionId;
    }

    public void setProviderTransactionId(ProviderTransactionIdValue providerTransactionId) {
        this.providerTransactionId = providerTransactionId;
    }

    public Name getName() {
        return this.name;
    }

    public void setName(Name name) {
        this.name = name;
    }

    public MessageValue getSenderNote() {
        return this.senderNote;
    }

    public void setSenderNote(MessageValue senderNote) {
        this.senderNote = senderNote;
    }

    public MessageValue getReceiverMessage() {
        return this.receiverMessage;
    }

    public void setReceiverMessage(MessageValue receiverMessage) {
        this.receiverMessage = receiverMessage;
    }

    public ReferenceIdValue getReferenceId() {
        return this.referenceId;
    }

    public void setReferenceId(ReferenceIdValue referenceId) {
        this.referenceId = referenceId;
    }

    public ExtensionType getExtension() {
        return this.extension;
    }

    public void setExtension(ExtensionType extension) {
        this.extension = extension;
    }

    @Override
    public QuoteId getQuoteId() {
        return this.quoteId;
    }

    @Override
    public void setQuoteId(QuoteId quoteId) {
        this.quoteId = quoteId;
    }
}

