/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.serviceprovider.v1_1.frontend.addpreapproval;

import com.ericsson.em.m3if.v1_0.common.AmountValue;
import com.ericsson.em.m3if.v1_0.common.CurrencyCode;
import com.ericsson.em.m3if.v1_0.common.ReferenceIdValue;
import com.ericsson.em.validators.IsFinancialResourceIdentifier;
import com.ericsson.em.validators.IsPositiveLong;
import com.ericsson.em.validators.IsRestrictedString;
import com.ericsson.em.validators.Length;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.joda.time.Duration;

@Deprecated
@XmlRootElement(namespace="http://www.ericsson.com/em/emm/serviceprovider/v1_1/frontend", name="addpreapprovalrequest")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/serviceprovider/v1_1/frontend", name="", propOrder={"fromFri", "fromFriCurrencyCode", "toFri", "toFriCurrencyCode", "message", "validityDuration", "maxDebitAmount", "referenceId"})
public class AddPreApprovalRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NotNull
    @IsFinancialResourceIdentifier
    @XmlElement(name="fromfri", required=true)
    private String fromFri;
    @Valid
    @XmlElement(name="fromfricurrency")
    private CurrencyCode fromFriCurrencyCode;
    @NotNull
    @IsFinancialResourceIdentifier
    @XmlElement(name="tofri", required=true)
    private String toFri;
    @Valid
    @XmlElement(name="tofricurrency")
    private CurrencyCode toFriCurrencyCode;
    @NotNull
    @Length(max=256)
    @IsRestrictedString
    @XmlElement(name="message", required=true)
    private String message;
    @IsPositiveLong
    @XmlElement(name="validityduration")
    private Long validityDuration;
    @Valid
    @XmlElement(name="maxdebitamount", type=AmountValue.class)
    private AmountValue maxDebitAmount;
    @Valid
    @XmlElement(name="referenceid", type=ReferenceIdValue.class)
    private ReferenceIdValue referenceId;

    public String getFromFri() {
        return this.fromFri;
    }

    public void setFromFri(String fromFri) {
        this.fromFri = fromFri;
    }

    public CurrencyCode getFromFriCurrencyCode() {
        return this.fromFriCurrencyCode;
    }

    public void setFromFriCurrencyCode(CurrencyCode code) {
        this.fromFriCurrencyCode = code;
    }

    public String getToFri() {
        return this.toFri;
    }

    public void setToFri(String toFri) {
        this.toFri = toFri;
    }

    public CurrencyCode getToFriCurrencyCode() {
        return this.toFriCurrencyCode;
    }

    public void setToFriCurrencyCode(CurrencyCode code) {
        this.toFriCurrencyCode = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Optional<Duration> getValidityDuration() {
        return this.validityDuration == null ? Optional.empty() : Optional.of(Duration.standardSeconds(this.validityDuration));
    }

    public void setValidityDuration(Duration validityDuration) {
        this.validityDuration = validityDuration != null ? Long.valueOf(validityDuration.getStandardSeconds()) : null;
    }

    @Nullable
    public AmountValue getMaxDebitAmount() {
        return this.maxDebitAmount;
    }

    public void setMaxDebitAmount(AmountValue maxDebitAmount) {
        this.maxDebitAmount = maxDebitAmount;
    }

    public ReferenceIdValue getReferenceId() {
        return this.referenceId;
    }

    public void setReferenceId(ReferenceIdValue referenceId) {
        this.referenceId = referenceId;
    }
}

