/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.serviceprovider.v1_1.backend.preapproval;

import com.ericsson.em.m3if.operations.annotations.SignedElements;
import com.ericsson.em.m3if.v1_0.common.CurrencyCode;
import com.ericsson.em.m3if.v1_0.common.ReferenceIdValue;
import com.ericsson.em.m3if.v1_0.common.UrlValue;
import com.ericsson.em.validators.IsFinancialResourceIdentifier;
import com.ericsson.em.validators.IsPositiveLong;
import com.ericsson.em.validators.IsRestrictedString;
import com.ericsson.em.validators.Length;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Currency;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.joda.time.Duration;

@Deprecated
@XmlRootElement(namespace="http://www.ericsson.com/em/emm/serviceprovider/v1_1/backend", name="preapprovalrequest")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/serviceprovider/v1_1/backend", name="", propOrder={"fromFRI", "fromFriCurrencyCode", "toFRI", "toFriCurrencyCode", "message", "validityDuration", "callbackUrl", "referenceId"})
@SignedElements(value={"fromfri", "fromfricurrency/code", "tofri", "tofricurrency/code"})
public class PreApprovalRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NotNull
    @IsFinancialResourceIdentifier
    @XmlElement(name="fromfri", required=true)
    private String fromFRI;
    @Valid
    @XmlElement(name="fromfricurrency", required=false)
    private CurrencyCode fromFriCurrencyCode;
    @NotNull
    @IsFinancialResourceIdentifier
    @XmlElement(name="tofri", required=true)
    private String toFRI;
    @Valid
    @XmlElement(name="tofricurrency", required=false)
    private CurrencyCode toFriCurrencyCode;
    @NotNull
    @IsRestrictedString
    @Length(max=256)
    @XmlElement(name="message", required=true)
    private String message;
    @IsPositiveLong
    @XmlElement(name="validityduration", required=false)
    private Long validityDuration;
    @Valid
    @XmlElement(name="callbackurl", type=UrlValue.class, required=false)
    private UrlValue callbackUrl;
    @Valid
    @XmlElement(name="referenceid", type=ReferenceIdValue.class, required=false)
    private ReferenceIdValue referenceId;

    public PreApprovalRequest() {
    }

    public PreApprovalRequest(String fromFri, Currency fromFriCurrency, String toFri, Currency toFriCurrency, String message, Long validityDuration) {
        this.fromFRI = fromFri;
        this.fromFriCurrencyCode = this.safeCurrencyCode(fromFriCurrency);
        this.toFRI = toFri;
        this.toFriCurrencyCode = this.safeCurrencyCode(toFriCurrency);
        this.message = message;
        this.validityDuration = validityDuration;
    }

    public String getFromFRI() {
        return this.fromFRI;
    }

    public void setFromFRI(String fromFRI) {
        this.fromFRI = fromFRI;
    }

    public String getToFRI() {
        return this.toFRI;
    }

    public void setToFRI(String toFRI) {
        this.toFRI = toFRI;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public CurrencyCode getFromFriCurrencyCode() {
        return this.fromFriCurrencyCode;
    }

    public void setFromFriCurrencyCode(CurrencyCode fromFriCurrencyCode) {
        this.fromFriCurrencyCode = fromFriCurrencyCode;
    }

    public CurrencyCode getToFriCurrencyCode() {
        return this.toFriCurrencyCode;
    }

    public void setToFriCurrencyCode(CurrencyCode toFriCurrencyCode) {
        this.toFriCurrencyCode = toFriCurrencyCode;
    }

    public Optional<Duration> getValidityDuration() {
        return this.validityDuration == null ? Optional.empty() : Optional.of(Duration.standardSeconds(this.validityDuration));
    }

    public void setValidityDuration(Optional<Duration> validityDuration) {
        this.validityDuration = validityDuration.map(Duration::getStandardSeconds).orElse(null);
    }

    private CurrencyCode safeCurrencyCode(Currency fromFriCurrency) {
        return fromFriCurrency == null ? null : new CurrencyCode(fromFriCurrency.getCurrencyCode());
    }

    public UrlValue getCallbackUrl() {
        return this.callbackUrl;
    }

    public void setCallbackUrl(UrlValue callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public ReferenceIdValue getReferenceId() {
        return this.referenceId;
    }

    public void setReferenceId(ReferenceIdValue referenceId) {
        this.referenceId = referenceId;
    }
}

