/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.serviceprovider.v1_1.backend.client.withdraw;

import com.ericsson.em.m3if.operations.annotations.SignedElements;
import com.ericsson.em.m3if.operations.validation.IsPositiveAmount;
import com.ericsson.em.m3if.v1_0.common.ExtensionType;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.m3if.v1_0.common.TransmissionCounter;
import com.ericsson.em.validators.IsFinancialResourceIdentifier;
import com.ericsson.em.validators.IsIdentity;
import com.ericsson.em.validators.IsRestrictedString;
import com.ericsson.em.validators.Length;
import com.ericsson.em.validators.NotEmpty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(namespace="http://www.ericsson.com/em/emm/serviceprovider/v1_1/backend/client", name="withdrawrequest")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/serviceprovider/v1_1/backend/client", name="", propOrder={"resource", "accountHolderId", "amount", "transactionId", "message", "transmissionCounter", "extension"})
@SignedElements(value={"resource", "accountholderid", "amount/amount", "amount/currency", "transactionid"})
public class WithdrawRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NotEmpty
    @IsFinancialResourceIdentifier
    @XmlElement(name="resource", required=true)
    private String resource;
    @NotEmpty
    @IsIdentity
    @XmlElement(name="accountholderid", required=true)
    private String accountHolderId;
    @Valid
    @NotNull
    @XmlElement(name="amount", type=MoneyDetails.class, required=true)
    @IsPositiveAmount
    private MoneyDetails amount;
    @NotNull
    @XmlElement(name="transactionid", required=true)
    private long transactionId;
    @Length(max=256)
    @IsRestrictedString
    @XmlElement(name="message")
    private String message;
    @Valid
    @XmlElement(name="transmissioncounter", type=TransmissionCounter.class, required=false)
    private TransmissionCounter transmissionCounter;
    @Valid
    @XmlElement(name="extension")
    private ExtensionType extension;

    public WithdrawRequest() {
    }

    public WithdrawRequest(String resource, String acctHolderId, MoneyDetails amount, long transactionId, String message, ExtensionType extension) {
        this.setResource(resource);
        this.setAccountHolderId(acctHolderId);
        this.setAmount(amount);
        this.setTransactionId(transactionId);
        this.setMessage(message);
        this.setExtension(extension);
    }

    public WithdrawRequest(String resource, String acctHolderId, MoneyDetails amount, long transactionId, String message, TransmissionCounter transmissionCounter, ExtensionType extension) {
        this(resource, acctHolderId, amount, transactionId, message, extension);
        this.setTransmissionCounter(transmissionCounter);
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public MoneyDetails getAmount() {
        return this.amount;
    }

    public void setAmount(MoneyDetails amount) {
        this.amount = amount;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public ExtensionType getExtension() {
        return this.extension;
    }

    public void setExtension(ExtensionType extension) {
        this.extension = extension;
    }

    public String getAccountHolderId() {
        return this.accountHolderId;
    }

    public void setAccountHolderId(String accountHolderId) {
        this.accountHolderId = accountHolderId;
    }

    public long getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(long transactionId) {
        this.transactionId = transactionId;
    }

    public TransmissionCounter getTransmissionCounter() {
        return this.transmissionCounter;
    }

    public void setTransmissionCounter(TransmissionCounter transmissionCounter) {
        this.transmissionCounter = transmissionCounter;
    }
}

