/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.serviceprovider.v1_0.frontend.cashpayment;

import com.ericsson.em.m3if.operations.validation.IsPositiveAmount;
import com.ericsson.em.m3if.v1_0.common.ExtensionType;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.m3if.v1_0.common.OfferIdentity;
import com.ericsson.em.validators.IsExternalReferenceString;
import com.ericsson.em.validators.IsRestrictedString;
import com.ericsson.em.validators.Length;
import com.ericsson.em.validators.NoNullElements;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(namespace="http://www.ericsson.com/em/emm/serviceprovider/v1_0/frontend", name="cashpaymentresponse")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/serviceprovider/v1_0/frontend", name="", propOrder={"fee", "discount", "transactionId", "senderBalanceAfter", "paymentToken", "message", "extension", "offerIdentities"})
public class CashPaymentResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Valid
    @XmlElement(name="fee", type=MoneyDetails.class)
    @IsPositiveAmount
    private MoneyDetails fee;
    @Valid
    @XmlElement(name="discount", type=MoneyDetails.class)
    @IsPositiveAmount
    private MoneyDetails discount;
    @NotNull
    @XmlElement(name="transactionid", required=false)
    private Long transactionId;
    @Valid
    @XmlElement(name="senderbalanceafter", type=MoneyDetails.class)
    @IsPositiveAmount
    private MoneyDetails senderBalanceAfter;
    @Length(max=64)
    @IsExternalReferenceString
    @XmlElement(name="paymenttoken")
    private String paymentToken;
    @Length(max=256)
    @IsRestrictedString
    @XmlElement(name="message")
    private String message;
    @Valid
    @XmlElement(name="extension")
    private ExtensionType extension;
    @Valid
    @NoNullElements
    @XmlElementWrapper(name="offeridentities")
    @XmlElements(value={@XmlElement(name="offeridentity", required=true, type=OfferIdentity.class)})
    private List<OfferIdentity> offerIdentities;

    public CashPaymentResponse() {
    }

    public CashPaymentResponse(MoneyDetails fee, MoneyDetails discount, long transactionId, MoneyDetails senderBalance, String paymentToken, String message, ExtensionType extension, List<OfferIdentity> offerIdentities) {
        this.setFee(fee);
        this.setDiscount(discount);
        this.setTransactionId(transactionId);
        this.setSenderBalanceAfter(senderBalance);
        this.setPaymentToken(paymentToken);
        this.setMessage(message);
        this.setExtension(extension);
        this.setOfferIdentities(offerIdentities);
    }

    public MoneyDetails getFee() {
        return this.fee;
    }

    public void setFee(MoneyDetails fee) {
        this.fee = fee;
    }

    public MoneyDetails getDiscount() {
        return this.discount;
    }

    public void setDiscount(MoneyDetails discount) {
        this.discount = discount;
    }

    public Long getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(Long transactionId) {
        this.transactionId = transactionId;
    }

    public MoneyDetails getSenderBalanceAfter() {
        return this.senderBalanceAfter;
    }

    public void setSenderBalanceAfter(MoneyDetails senderBalanceAfter) {
        this.senderBalanceAfter = senderBalanceAfter;
    }

    public String getPaymentToken() {
        return this.paymentToken;
    }

    public void setPaymentToken(String paymentToken) {
        this.paymentToken = paymentToken;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public ExtensionType getExtension() {
        return this.extension;
    }

    public void setExtension(ExtensionType extension) {
        this.extension = extension;
    }

    public List<OfferIdentity> getOfferIdentities() {
        return this.offerIdentities;
    }

    public void setOfferIdentities(List<OfferIdentity> offerIdentities) {
        this.offerIdentities = offerIdentities;
    }
}

