/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.serviceprovider.v1_0.frontend.addpreapproval;

import com.ericsson.em.m3if.v1_0.common.CurrencyCode;
import com.ericsson.em.validators.IsFinancialResourceIdentifier;
import com.ericsson.em.validators.IsRestrictedString;
import com.ericsson.em.validators.Length;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Currency;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@Deprecated
@XmlRootElement(namespace="http://www.ericsson.com/em/emm/serviceprovider/v1_0/frontend", name="addpreapprovalrequest")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/serviceprovider/v1_0/frontend", name="", propOrder={"fromFri", "fromFriCurrencyCode", "toFri", "toFriCurrencyCode", "message"})
public class AddPreApprovalRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlAttribute
    public static final String version = "1.0";
    @NotNull
    @IsFinancialResourceIdentifier
    @XmlElement(name="fromfri", required=true)
    private String fromFri;
    @Valid
    @XmlElement(name="fromfricurrency", required=false)
    private CurrencyCode fromFriCurrencyCode;
    @NotNull
    @IsFinancialResourceIdentifier
    @XmlElement(name="tofri", required=true)
    private String toFri;
    @Valid
    @XmlElement(name="tofricurrency", required=false)
    private CurrencyCode toFriCurrencyCode;
    @NotNull
    @Length(max=256)
    @IsRestrictedString
    @XmlElement(name="message", required=true)
    private String message;

    public AddPreApprovalRequest() {
    }

    public AddPreApprovalRequest(String fromFri, String toFri, String message) {
        this(fromFri, null, toFri, null, message);
    }

    public AddPreApprovalRequest(String fromFri, Currency fromFriCurrency, String toFri, Currency toFriCurrency, String message) {
        this.fromFri = fromFri;
        this.fromFriCurrencyCode = this.safeCurrencyCode(fromFriCurrency);
        this.toFri = toFri;
        this.toFriCurrencyCode = this.safeCurrencyCode(toFriCurrency);
        this.message = message;
    }

    private CurrencyCode safeCurrencyCode(Currency fromFriCurrency) {
        return fromFriCurrency == null ? null : new CurrencyCode(fromFriCurrency.getCurrencyCode());
    }

    public String getFromFri() {
        return this.fromFri;
    }

    public void setFromFri(String fromFri) {
        this.fromFri = fromFri;
    }

    public CurrencyCode getFromFriCurrencyCode() {
        return this.fromFriCurrencyCode;
    }

    public void setFromFriCurrencyCode(CurrencyCode code) {
        this.fromFriCurrencyCode = code;
    }

    public String getToFri() {
        return this.toFri;
    }

    public void setToFri(String toFri) {
        this.toFri = toFri;
    }

    public CurrencyCode getToFriCurrencyCode() {
        return this.toFriCurrencyCode;
    }

    public void setToFriCurrencyCode(CurrencyCode code) {
        this.toFriCurrencyCode = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}

