/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.rds.v1_0.sessionlog;

import com.ericsson.em.m3if.v1_0.common.Iso8601DateTime;
import com.ericsson.em.validation.Validation;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.io.Serializable;

public class SessionLogEventRecord
implements Serializable {
    private static final long serialVersionUID = -5541341007809806442L;
    @Size(max=64)
    private final @Size(max=64) String action;
    private final Long sessionId;
    @Valid
    @NotNull
    private final Iso8601DateTime loggingTime;
    @Size(max=272)
    private final @Size(max=272) String who;
    @Size(max=32)
    private final @Size(max=32) String protocol;
    @Size(max=64)
    private final @Size(max=64) String address;
    @Size(max=64)
    private final @Size(max=64) String details;

    SessionLogEventRecord(Builder builder) {
        this.action = builder.action;
        this.sessionId = builder.sessionId;
        this.loggingTime = builder.loggingTime;
        this.who = builder.who;
        this.protocol = builder.protocol;
        this.address = builder.address;
        this.details = builder.details;
    }

    public String getAction() {
        return this.action;
    }

    public Long getSessionId() {
        return this.sessionId;
    }

    public Iso8601DateTime getLoggingTime() {
        return this.loggingTime;
    }

    public String getWho() {
        return this.who;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getAddress() {
        return this.address;
    }

    public String getDetails() {
        return this.details;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private String action;
        private Long sessionId;
        private Iso8601DateTime loggingTime;
        private String who;
        private String protocol;
        private String address;
        private String details;

        public Builder action(String action) {
            this.action = action;
            return this;
        }

        public Builder sessionId(Long sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public Builder loggingTime(Iso8601DateTime loggingTime) {
            this.loggingTime = loggingTime;
            return this;
        }

        public Builder who(String who) {
            this.who = who;
            return this;
        }

        public Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder address(String address) {
            this.address = address;
            return this;
        }

        public Builder details(String details) {
            this.details = details;
            return this;
        }

        public SessionLogEventRecord build() {
            return Validation.validate(new SessionLogEventRecord(this));
        }
    }
}

