/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.rds.v1_0.externalinstrument;

import com.ericsson.em.m3if.rds.v1_0.externalinstrument.AdditionalInformation;
import com.ericsson.em.m3if.v1_0.common.Iso8601DateTime;
import com.ericsson.em.validation.Validation;
import com.ericsson.em.validators.IsExternalReferenceString;
import com.ericsson.em.validators.IsFinancialResourceIdentifier;
import com.ericsson.em.validators.IsIdentity;
import com.ericsson.em.validators.IsMultiWordString;
import com.ericsson.em.validators.IsMultilineRestrictedString;
import com.ericsson.em.validators.IsRestrictedString;
import com.ericsson.em.validators.IsSingleWordString;
import com.ericsson.em.validators.IsUsername;
import com.ericsson.em.validators.NoNullElements;
import com.ericsson.em.validators.NotBlank;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ExternalInstrument
implements Serializable {
    @IsIdentity
    @NotNull
    @NotBlank
    private final String instrumentOwner;
    @IsFinancialResourceIdentifier
    @Size(max=256)
    @NotNull
    @NotBlank
    private final @Size(max=256) @NotNull String instrumentFri;
    @IsExternalReferenceString
    @Size(max=128)
    private final @Size(max=128) String instrumentReference;
    @IsMultiWordString
    @Size(max=64)
    @NotNull
    @NotBlank
    private final @Size(max=64) @NotNull String providerName;
    @IsUsername
    @Size(max=64)
    @NotNull
    @NotBlank
    private final @Size(max=64) @NotNull String providerUsername;
    @IsSingleWordString
    @Size(max=64)
    @NotNull
    @NotBlank
    private final @Size(max=64) @NotNull String instrumentType;
    @IsSingleWordString
    @Size(max=32)
    @NotNull
    @NotBlank
    private final @Size(max=32) @NotNull String status;
    @IsSingleWordString
    @Size(max=64)
    private final @Size(max=64) String instrumentSubtype;
    @IsRestrictedString
    @Size(max=64)
    private final @Size(max=64) String maskedInstrumentNumber;
    @IsMultiWordString
    @Size(max=64)
    private final @Size(max=64) String instrumentIssuer;
    @IsMultiWordString
    @Size(max=64)
    private final @Size(max=64) String instrumentBrand;
    @IsMultilineRestrictedString
    @Size(max=256)
    private final @Size(max=256) String reason;
    @Valid
    @NotNull
    private final Iso8601DateTime lastUpdatedTimestamp;
    @Valid
    @NotNull
    @NoNullElements
    private final List<AdditionalInformation> additionalInformation;

    ExternalInstrument(Builder builder) {
        this.instrumentOwner = builder.instrumentOwner;
        this.instrumentFri = builder.instrumentFri;
        this.instrumentReference = builder.instrumentReference;
        this.providerName = builder.providerName;
        this.providerUsername = builder.providerUsername;
        this.instrumentType = builder.instrumentType;
        this.instrumentSubtype = builder.instrumentSubtype;
        this.status = builder.status;
        this.maskedInstrumentNumber = builder.maskedInstrumentNumber;
        this.instrumentIssuer = builder.instrumentIssuer;
        this.instrumentBrand = builder.instrumentBrand;
        this.reason = builder.reason;
        this.lastUpdatedTimestamp = builder.lastUpdatedTimestamp;
        this.additionalInformation = builder.additionalInformation;
    }

    public String getInstrumentOwner() {
        return this.instrumentOwner;
    }

    public String getInstrumentFri() {
        return this.instrumentFri;
    }

    public String getInstrumentReference() {
        return this.instrumentReference;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public String getProviderUsername() {
        return this.providerUsername;
    }

    public String getInstrumentType() {
        return this.instrumentType;
    }

    public String getStatus() {
        return this.status;
    }

    public String getInstrumentSubtype() {
        return this.instrumentSubtype;
    }

    public String getMaskedInstrumentNumber() {
        return this.maskedInstrumentNumber;
    }

    public String getInstrumentIssuer() {
        return this.instrumentIssuer;
    }

    public String getInstrumentBrand() {
        return this.instrumentBrand;
    }

    public String getReason() {
        return this.reason;
    }

    public Iso8601DateTime getLastUpdatedTimestamp() {
        return this.lastUpdatedTimestamp;
    }

    public List<AdditionalInformation> getAdditionalInformation() {
        return this.additionalInformation;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder builderFrom(ExternalInstrument externalInstrument) {
        return new Builder(externalInstrument);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalInstrument that = (ExternalInstrument)o;
        return this.instrumentOwner.equals(that.instrumentOwner) && this.instrumentFri.equals(that.instrumentFri) && this.instrumentReference.equals(that.instrumentReference) && this.providerName.equals(that.providerName) && this.providerUsername.equals(that.providerUsername) && this.instrumentType.equals(that.instrumentType) && this.status.equals(that.status) && Objects.equals(this.instrumentSubtype, that.instrumentSubtype) && Objects.equals(this.maskedInstrumentNumber, that.maskedInstrumentNumber) && Objects.equals(this.instrumentIssuer, that.instrumentIssuer) && Objects.equals(this.instrumentBrand, that.instrumentBrand) && Objects.equals(this.reason, that.reason) && this.lastUpdatedTimestamp.equals(that.lastUpdatedTimestamp) && this.additionalInformation.equals(that.additionalInformation);
    }

    public int hashCode() {
        return Objects.hash(this.instrumentOwner, this.instrumentFri, this.instrumentReference, this.providerName, this.providerUsername, this.instrumentType, this.status, this.instrumentSubtype, this.maskedInstrumentNumber, this.instrumentIssuer, this.instrumentBrand, this.reason, this.lastUpdatedTimestamp, this.additionalInformation);
    }

    public static final class Builder {
        private String instrumentOwner;
        private String instrumentFri;
        private String instrumentReference;
        private String providerName;
        private String providerUsername;
        private String instrumentType;
        private String instrumentSubtype;
        private String status;
        private String maskedInstrumentNumber;
        private String instrumentIssuer;
        private String instrumentBrand;
        private String reason;
        private Iso8601DateTime lastUpdatedTimestamp;
        private List<AdditionalInformation> additionalInformation = new ArrayList<AdditionalInformation>();

        Builder() {
        }

        Builder(ExternalInstrument externalInstrument) {
            this.instrumentOwner = externalInstrument.instrumentOwner;
            this.instrumentFri = externalInstrument.instrumentFri;
            this.instrumentReference = externalInstrument.instrumentReference;
            this.providerName = externalInstrument.providerName;
            this.providerUsername = externalInstrument.providerUsername;
            this.instrumentType = externalInstrument.instrumentType;
            this.instrumentSubtype = externalInstrument.instrumentSubtype;
            this.status = externalInstrument.status;
            this.maskedInstrumentNumber = externalInstrument.maskedInstrumentNumber;
            this.instrumentIssuer = externalInstrument.instrumentIssuer;
            this.instrumentBrand = externalInstrument.instrumentBrand;
            this.reason = externalInstrument.reason;
            this.lastUpdatedTimestamp = externalInstrument.lastUpdatedTimestamp;
            this.additionalInformation = externalInstrument.additionalInformation;
        }

        public Builder instrumentOwner(String val) {
            this.instrumentOwner = val;
            return this;
        }

        public Builder instrumentFri(String val) {
            this.instrumentFri = val;
            return this;
        }

        public Builder instrumentReference(String val) {
            this.instrumentReference = val;
            return this;
        }

        public Builder providerName(String val) {
            this.providerName = val;
            return this;
        }

        public Builder providerUsername(String val) {
            this.providerUsername = val;
            return this;
        }

        public Builder instrumentType(String val) {
            this.instrumentType = val;
            return this;
        }

        public Builder instrumentSubtype(String val) {
            this.instrumentSubtype = val;
            return this;
        }

        public Builder status(String val) {
            this.status = val;
            return this;
        }

        public Builder maskedInstrumentNumber(String val) {
            this.maskedInstrumentNumber = val;
            return this;
        }

        public Builder instrumentIssuer(String val) {
            this.instrumentIssuer = val;
            return this;
        }

        public Builder instrumentBrand(String val) {
            this.instrumentBrand = val;
            return this;
        }

        public Builder reason(String val) {
            this.reason = val;
            return this;
        }

        public Builder lastUpdatedTimestamp(Iso8601DateTime val) {
            this.lastUpdatedTimestamp = val;
            return this;
        }

        public Builder additionalInformation(List<AdditionalInformation> val) {
            this.additionalInformation = val;
            return this;
        }

        public ExternalInstrument build() {
            return Validation.validate(new ExternalInstrument(this));
        }
    }
}

