/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.rds.v1_0.audittraillog;

import com.ericsson.em.m3if.rds.v1_0.audittraillog.AuditTrailLogStatus;
import com.ericsson.em.m3if.rds.v1_0.location.LocationData;
import com.ericsson.em.m3if.v1_0.common.IdentityValue;
import com.ericsson.em.m3if.v1_0.common.Iso8601DateTime;
import com.ericsson.em.validation.Validation;
import com.ericsson.em.validators.NotEmpty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.io.Serializable;

public class AuditTrailLogEventRecord
implements Serializable {
    private static final long serialVersionUID = 8942404771147320745L;
    @Valid
    private final IdentityValue initiatingUser;
    @Valid
    private final IdentityValue realUser;
    @Valid
    private final IdentityValue accountholder;
    @Valid
    @NotNull
    private final Iso8601DateTime loggingTime;
    private final Long sessionId;
    private final Long approvalId;
    @Size(max=128)
    @NotEmpty
    private final @Size(max=128) String transactionType;
    private final AuditTrailLogStatus status;
    @Valid
    private final LocationData locationData;

    public IdentityValue getInitiatingUser() {
        return this.initiatingUser;
    }

    public IdentityValue getRealUser() {
        return this.realUser;
    }

    public IdentityValue getAccountholder() {
        return this.accountholder;
    }

    public Iso8601DateTime getLoggingTime() {
        return this.loggingTime;
    }

    public Long getSessionId() {
        return this.sessionId;
    }

    public String getTransactionType() {
        return this.transactionType;
    }

    public AuditTrailLogStatus getStatus() {
        return this.status;
    }

    public LocationData getLocationData() {
        return this.locationData;
    }

    public Long getApprovalId() {
        return this.approvalId;
    }

    AuditTrailLogEventRecord(Builder builder) {
        this.initiatingUser = IdentityValue.fromString(builder.initiatingUser);
        this.realUser = IdentityValue.fromString(builder.realUser);
        this.accountholder = IdentityValue.fromString(builder.accountholder);
        this.loggingTime = builder.loggingTime;
        this.sessionId = builder.sessionId;
        this.transactionType = builder.transactionType;
        this.status = builder.status;
        this.locationData = builder.locationData;
        this.approvalId = builder.approvalId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private String initiatingUser;
        private String realUser;
        private String accountholder;
        private Iso8601DateTime loggingTime;
        private Long sessionId;
        private String transactionType;
        private AuditTrailLogStatus status;
        private LocationData locationData;
        private Long approvalId;

        public Builder initiatingUser(String initiatingUser) {
            this.initiatingUser = initiatingUser;
            return this;
        }

        public Builder realUser(String realUser) {
            this.realUser = realUser;
            return this;
        }

        public Builder accountholder(String accountholder) {
            this.accountholder = accountholder;
            return this;
        }

        public Builder loggingTime(Iso8601DateTime loggingTime) {
            this.loggingTime = loggingTime;
            return this;
        }

        public Builder sessionId(Long sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public Builder transactionType(String transactionType) {
            this.transactionType = transactionType;
            return this;
        }

        public Builder status(AuditTrailLogStatus status) {
            this.status = status;
            return this;
        }

        public Builder locationData(LocationData locationData) {
            this.locationData = locationData;
            return this;
        }

        public Builder approvalId(Long approvalId) {
            this.approvalId = approvalId;
            return this;
        }

        public AuditTrailLogEventRecord build() {
            return Validation.validate(new AuditTrailLogEventRecord(this));
        }
    }
}

