/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.provisioning.v1_0.setaccountholderadditionalinformation;

import com.ericsson.em.m3if.provisioning.v1_0.common.AdditionalInformation;
import com.ericsson.em.validators.IsIdentity;
import com.ericsson.em.validators.IsMultilineRestrictedString;
import com.ericsson.em.validators.Length;
import com.ericsson.em.validators.NoNullElements;
import com.ericsson.em.validators.NotBlank;
import jakarta.validation.Valid;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(namespace="http://www.ericsson.com/em/emm/provisioning/v1_0", name="setaccountholderadditionalinformationrequest")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/provisioning/v1_0", name="", propOrder={"identity", "reason", "additionalInformation"})
public class SetAccountHolderAdditionalInformationRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="identity", required=false)
    @IsIdentity
    private String identity;
    @NotBlank
    @Length(max=512)
    @IsMultilineRestrictedString
    @XmlElement(name="reason", required=true)
    private String reason;
    @Valid
    @NoNullElements
    @XmlElementWrapper(name="additionalinformationlist")
    @XmlElements(value={@XmlElement(name="additionalinformation", type=AdditionalInformation.class)})
    private List<AdditionalInformation> additionalInformation;

    public String getIdentity() {
        return this.identity;
    }

    public void setIdentity(String identity) {
        this.identity = identity;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public List<AdditionalInformation> getAdditionalInformation() {
        if (this.additionalInformation == null) {
            this.additionalInformation = new ArrayList<AdditionalInformation>();
        }
        return this.additionalInformation;
    }

    public void setAdditionalInformation(List<AdditionalInformation> additionalInformation) {
        this.additionalInformation = additionalInformation;
    }

    public void setAdditionalInformation(String name, String value) {
        if (name != null) {
            List<AdditionalInformation> aiList = this.getAdditionalInformation();
            Iterator<AdditionalInformation> iterator = aiList.iterator();
            while (iterator.hasNext()) {
                AdditionalInformation ai = iterator.next();
                if (!name.equalsIgnoreCase(ai.getName())) continue;
                if (value != null) {
                    ai.setValue(value);
                } else {
                    iterator.remove();
                }
                return;
            }
            if (value != null) {
                aiList.add(new AdditionalInformation(name, value));
            }
        }
    }

    public String getAdditionalInformation(String name) {
        if (name != null) {
            for (AdditionalInformation ai : this.getAdditionalInformation()) {
                if (!name.equalsIgnoreCase(ai.getName())) continue;
                return ai.getValue();
            }
        }
        return null;
    }
}

