/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.provisioning.v1_0.listaccountholders;

import com.ericsson.em.m3if.v1_0.common.IdentityValue;
import com.ericsson.em.m3if.v1_3.common.AccountHolderBasicInfo;
import com.ericsson.em.validators.NoNullElements;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(namespace="http://www.ericsson.com/em/emm/provisioning/v1_0", name="listaccountholdersresponse")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/provisioning/v1_0", name="", propOrder={"accountHolderInfoList", "pointOfSalesList"})
public class ListAccountHoldersResponse {
    @Valid
    @NotNull
    @NoNullElements
    @XmlElementWrapper(name="accountholderinfolist", required=true)
    @XmlElements(value={@XmlElement(name="accountholderbasicinfo", type=AccountHolderBasicInfo.class)})
    private final List<AccountHolderBasicInfo> accountHolderInfoList = new ArrayList<AccountHolderBasicInfo>();
    @Valid
    @NotNull
    @NoNullElements
    @XmlElementWrapper(name="pointofsaleslist", required=true)
    @XmlElements(value={@XmlElement(name="identity", type=IdentityValue.class)})
    private final List<IdentityValue> pointOfSalesList = new ArrayList<IdentityValue>();

    public ListAccountHoldersResponse() {
    }

    public ListAccountHoldersResponse(List<AccountHolderBasicInfo> accountHolderInfoList, List<IdentityValue> pointOfSalesList) {
        this.setAccountHolderInfoList(accountHolderInfoList);
        this.setPointOfSalesList(pointOfSalesList);
    }

    public void setAccountHolderInfoList(List<AccountHolderBasicInfo> accountHolderInfoList) {
        if (accountHolderInfoList != null) {
            this.accountHolderInfoList.clear();
            this.accountHolderInfoList.addAll(accountHolderInfoList);
        }
    }

    public void addUniqueAccountHolderBasicInfo(AccountHolderBasicInfo info) {
        if (info != null && this.accountHolderInfoList.stream().noneMatch(existingInfo -> existingInfo.getIdentityValues().containsAll(info.getIdentityValues()))) {
            this.accountHolderInfoList.add(info);
        }
    }

    public List<AccountHolderBasicInfo> getAccountHolderInfoList() {
        return this.accountHolderInfoList;
    }

    public void setPointOfSalesList(List<IdentityValue> pointOfSalesList) {
        if (pointOfSalesList != null) {
            this.pointOfSalesList.clear();
            this.pointOfSalesList.addAll(pointOfSalesList);
        }
    }

    public void addUniquePointOfSales(IdentityValue identity) {
        if (identity != null && this.pointOfSalesList.stream().noneMatch(existingIdentity -> existingIdentity.equals(identity))) {
            this.pointOfSalesList.add(identity);
        }
    }

    public List<IdentityValue> getPointOfSalesList() {
        return this.pointOfSalesList;
    }
}

