/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.operations.validation.impl;

import com.ericsson.em.m3if.operations.validation.IsDateTimeValue;
import com.ericsson.em.m3if.v1_0.common.DateTimeValue;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class IsDateTimeValueValidator
implements ConstraintValidator<IsDateTimeValue, DateTimeValue> {
    private XMLGregorianCalendar minDateCalendar;

    @Override
    public void initialize(IsDateTimeValue annotation) {
        try {
            this.minDateCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(annotation.minDate());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("minDate parameter is not a valid date. (yyyy-mm-dd)");
        }
    }

    @Override
    public boolean isValid(DateTimeValue value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        return value.getTimestamp() != null && value.getTimestamp().compare(this.minDateCalendar) >= 0;
    }
}

