/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.operations.utils;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.joda.time.Chronology;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.base.AbstractInstant;
import org.joda.time.chrono.ISOChronology;

public final class DateHelper {
    private DateHelper() {
    }

    public static DateTime fromDate(Date date) {
        return date == null ? null : new DateTime(date);
    }

    public static Date toDate(AbstractInstant dateTime) {
        return dateTime == null ? null : dateTime.toDate();
    }

    public static DateTime fromCalendar(Calendar calendar) {
        return calendar == null ? null : new DateTime((Object)calendar, (Chronology)ISOChronology.getInstance());
    }

    public static DateMidnight dateMidnightFromDate(Date date) {
        return date == null ? null : new DateMidnight(date);
    }

    public static DateTime toDateTime(XMLGregorianCalendar calendar) {
        if (calendar != null) {
            return new DateTime(calendar.toGregorianCalendar());
        }
        return null;
    }

    public static org.joda.time.LocalDate toLocalDate(XMLGregorianCalendar calendar) {
        if (calendar != null) {
            return new org.joda.time.LocalDate(calendar.toGregorianCalendar());
        }
        return null;
    }

    public static XMLGregorianCalendar fromDateTime(DateTime dateTime) {
        try {
            if (dateTime != null) {
                return DatatypeFactory.newInstance().newXMLGregorianCalendar(dateTime.toGregorianCalendar());
            }
            return null;
        }
        catch (DatatypeConfigurationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static XMLGregorianCalendar fromLocalDate(org.joda.time.LocalDate date) {
        try {
            if (date != null) {
                return DatatypeFactory.newInstance().newXMLGregorianCalendarDate(date.getYear(), date.getMonthOfYear(), date.getDayOfMonth(), Integer.MIN_VALUE);
            }
            return null;
        }
        catch (DatatypeConfigurationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static LocalDate jodaLocalDateToJavaLocalDate(org.joda.time.LocalDate date) {
        if (date != null) {
            return LocalDate.of(date.getYear(), date.getMonthOfYear(), date.getDayOfMonth());
        }
        return null;
    }

    public static LocalDateTime jodaDateTimeToJavaLocalDateTime(DateTime dateTime) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(dateTime.getMillis()), ZoneId.of(dateTime.getZone().getID()));
    }

    public static DateTime javaLocalDateTimeToJodaDateTime(LocalDateTime localDateTime) {
        return new DateTime(localDateTime.getYear(), localDateTime.getMonthValue(), localDateTime.getDayOfMonth(), localDateTime.getHour(), localDateTime.getMinute(), localDateTime.getSecond(), localDateTime.getNano() / 1000000);
    }
}

