/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.operations.adapter;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public class DateAdapter
extends XmlAdapter<String, Date> {
    private static final String DATETIME_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";
    private static final Pattern MILLISECONDS_PATTERN = Pattern.compile("\\.\\d\\d?\\+");

    @Override
    public Date unmarshal(String v) throws Exception {
        return new SimpleDateFormat(DATETIME_PATTERN, Locale.US).parse(this.checkAndFixMillisecondsPart(v));
    }

    @Override
    public String marshal(Date v) throws Exception {
        return new SimpleDateFormat(DATETIME_PATTERN, Locale.US).format(v);
    }

    private String checkAndFixMillisecondsPart(String v) {
        if (v == null) {
            return null;
        }
        Matcher matcher = MILLISECONDS_PATTERN.matcher(v);
        if (matcher.find()) {
            String millisecondsPart = matcher.group();
            v = matcher.replaceFirst("." + String.format("%1$-3s", millisecondsPart.substring(1, millisecondsPart.length() - 1)).replace(' ', '0') + "+");
        }
        return v;
    }
}

