/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.financial.v2_3.common;

import com.ericsson.em.m3if.financial.v1_0.common.TaxDetail;
import com.ericsson.em.m3if.financial.v1_0.common.UserApprovalStatus;
import com.ericsson.em.m3if.financial.v1_1.common.UserApprovalType;
import com.ericsson.em.m3if.operations.validation.IsPositiveAmount;
import com.ericsson.em.m3if.v1_0.common.AccountDescriptionValue;
import com.ericsson.em.m3if.v1_0.common.ApprovalIdValue;
import com.ericsson.em.m3if.v1_0.common.FRIValue;
import com.ericsson.em.m3if.v1_0.common.FinancialTransactionId;
import com.ericsson.em.m3if.v1_0.common.IdentityValue;
import com.ericsson.em.m3if.v1_0.common.Iso8601DateTime;
import com.ericsson.em.m3if.v1_0.common.MessageValue;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.m3if.v1_0.common.OfferIdentity;
import com.ericsson.em.validators.NoNullElements;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlType;
import org.joda.time.DateTime;

@Deprecated
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/financial/v2_3/common", name="userapprovaldetails", propOrder={"approvalId", "financialTransactionId", "approvalType", "approvalExpiryTime", "status", "amount", "fee", "discount", "offerIdentities", "initiatingAccountHolderId", "message", "accountFRI", "accountDescription", "taxDetails"})
public class UserApprovalDetails
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Valid
    @NotNull
    @XmlElement(name="approvalid", type=ApprovalIdValue.class, required=true)
    private ApprovalIdValue approvalId;
    @Valid
    @XmlElement(name="financialtransactionid", type=FinancialTransactionId.class, required=false)
    private FinancialTransactionId financialTransactionId;
    @Valid
    @NotNull
    @XmlElement(name="approvaltype", type=UserApprovalType.class, required=true)
    private UserApprovalType approvalType;
    @Valid
    @NotNull
    @XmlElement(name="approvalexpirytime", type=Iso8601DateTime.class, required=true)
    private Iso8601DateTime approvalExpiryTime;
    @Valid
    @NotNull
    @XmlElement(name="status", type=UserApprovalStatus.class, required=true)
    private UserApprovalStatus status;
    @Valid
    @XmlElement(name="amount", type=MoneyDetails.class, required=false)
    @IsPositiveAmount
    private MoneyDetails amount;
    @Valid
    @XmlElement(name="fee", type=MoneyDetails.class, required=false)
    @IsPositiveAmount
    private MoneyDetails fee;
    @Valid
    @XmlElement(name="discount", type=MoneyDetails.class, required=false)
    @IsPositiveAmount
    private MoneyDetails discount;
    @Valid
    @NoNullElements
    @XmlElementWrapper(name="offeridentities")
    @XmlElements(value={@XmlElement(name="offeridentity", required=false, type=OfferIdentity.class)})
    private List<OfferIdentity> offerIdentities;
    @Valid
    @XmlElement(name="initiatingaccountholderid", type=IdentityValue.class, required=false)
    private IdentityValue initiatingAccountHolderId;
    @Valid
    @XmlElement(name="message", type=MessageValue.class, required=false)
    private MessageValue message;
    @Valid
    @XmlElement(name="accountfri", type=FRIValue.class, required=false)
    private FRIValue accountFRI;
    @Valid
    @XmlElement(name="accountdescription", type=AccountDescriptionValue.class, required=false)
    private AccountDescriptionValue accountDescription;
    @Valid
    @NoNullElements
    @XmlElementWrapper(name="taxdetails")
    @XmlElements(value={@XmlElement(name="taxdetail", type=TaxDetail.class, required=false)})
    private List<TaxDetail> taxDetails;

    public ApprovalIdValue getApprovalId() {
        return this.approvalId;
    }

    public void setApprovalId(ApprovalIdValue approvalId) {
        this.approvalId = approvalId;
    }

    public FinancialTransactionId getFinancialTransactionId() {
        return this.financialTransactionId;
    }

    public void setFinancialTransactionId(FinancialTransactionId financialTransactionId) {
        this.financialTransactionId = financialTransactionId;
    }

    public UserApprovalType getApprovalType() {
        return this.approvalType;
    }

    public void setApprovalType(UserApprovalType approvalType) {
        this.approvalType = approvalType;
    }

    public DateTime getApprovalExpiryTime() {
        return this.approvalExpiryTime.getValueAsDateTime();
    }

    public void setApprovalExpiryTime(DateTime approvalExpiryTime) {
        this.approvalExpiryTime = Iso8601DateTime.fromDateTime(approvalExpiryTime);
    }

    public UserApprovalStatus getStatus() {
        return this.status;
    }

    public void setStatus(UserApprovalStatus status) {
        this.status = status;
    }

    public MoneyDetails getAmount() {
        return this.amount;
    }

    public void setAmount(MoneyDetails amount) {
        this.amount = amount;
    }

    public IdentityValue getInitiatingAccountHolderId() {
        return this.initiatingAccountHolderId;
    }

    public void setInitiatingAccountHolderId(IdentityValue initiatingAccountHolderId) {
        this.initiatingAccountHolderId = initiatingAccountHolderId;
    }

    public MoneyDetails getFee() {
        return this.fee;
    }

    public void setFee(MoneyDetails fee) {
        this.fee = fee;
    }

    public MoneyDetails getDiscount() {
        return this.discount;
    }

    public void setDiscount(MoneyDetails discount) {
        this.discount = discount;
    }

    public List<OfferIdentity> getOfferIdentities() {
        return this.offerIdentities;
    }

    public void setOfferIdentities(List<OfferIdentity> offerIdentities) {
        this.offerIdentities = offerIdentities;
    }

    public void setOfferIdentitiesAsString(List<String> offerIdentities) {
        if (offerIdentities != null) {
            this.offerIdentities = new ArrayList<OfferIdentity>(offerIdentities.size());
            for (String id : offerIdentities) {
                this.offerIdentities.add(new OfferIdentity(id));
            }
        }
    }

    public MessageValue getMessage() {
        return this.message;
    }

    public void setMessage(MessageValue message) {
        this.message = message;
    }

    public FRIValue getAccountFRI() {
        return this.accountFRI;
    }

    public void setAccountFRI(FRIValue accountFRI) {
        this.accountFRI = accountFRI;
    }

    public AccountDescriptionValue getAccountDescription() {
        return this.accountDescription;
    }

    public void setAccountDescription(AccountDescriptionValue accountDescription) {
        this.accountDescription = accountDescription;
    }

    public List<TaxDetail> getTaxDetails() {
        return this.taxDetails;
    }

    public void setTaxDetails(List<TaxDetail> taxDetails) {
        this.taxDetails = taxDetails;
    }
}

