/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.financial.v2_0.merchantpayment;

import com.ericsson.em.m3if.coupons.v1_0.common.Coupon;
import com.ericsson.em.m3if.financial.v1_0.quotation.QuoteRequest;
import com.ericsson.em.m3if.operations.validation.IsPositiveAmount;
import com.ericsson.em.m3if.v1_0.common.FRIValue;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.m3if.v1_0.common.QuoteId;
import com.ericsson.em.m3if.v1_0.common.RequestReferenceId;
import com.ericsson.em.validators.IsRestrictedString;
import com.ericsson.em.validators.Length;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@Deprecated
@XmlRootElement(namespace="http://www.ericsson.com/em/emm/financial/v2_0", name="merchantpaymentrequest")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/financial/v2_0", name="", propOrder={"sendingFRI", "receivingFRI", "amount", "senderNote", "receiverMessage", "quoteId", "coupon", "requestReferenceId"})
public class MerchantPaymentRequest
implements Serializable,
QuoteRequest {
    private static final long serialVersionUID = 1L;
    @Valid
    @XmlElement(name="sendingfri")
    private FRIValue sendingFRI;
    @NotNull
    @Valid
    @XmlElement(name="receivingfri")
    private FRIValue receivingFRI;
    @Valid
    @NotNull
    @IsPositiveAmount
    @XmlElement(name="amount", required=true)
    private MoneyDetails amount;
    @Length(max=256)
    @XmlElement(name="sendernote")
    @IsRestrictedString
    private String senderNote;
    @Length(max=256)
    @XmlElement(name="receivermessage")
    @IsRestrictedString
    private String receiverMessage;
    @Valid
    @XmlElement(name="quoteid")
    private QuoteId quoteId;
    @Valid
    @XmlElement(name="coupon", type=Coupon.class)
    private Coupon coupon;
    @Valid
    @XmlElement(name="requestreferenceid", required=false)
    private RequestReferenceId requestReferenceId;

    public MerchantPaymentRequest() {
    }

    public MerchantPaymentRequest(FRIValue from, FRIValue to, MoneyDetails amount) {
        this.sendingFRI = from;
        this.receivingFRI = to;
        this.amount = amount;
    }

    public MerchantPaymentRequest(FRIValue from, FRIValue to, MoneyDetails amount, String senderNote, String receiverMessage) {
        this(from, to, amount);
        this.senderNote = senderNote;
        this.receiverMessage = receiverMessage;
    }

    public FRIValue getSendingFRI() {
        return this.sendingFRI;
    }

    public void setSendingFRI(FRIValue from) {
        this.sendingFRI = from;
    }

    public FRIValue getReceivingFRI() {
        return this.receivingFRI;
    }

    public void setReceivingFRI(FRIValue to) {
        this.receivingFRI = to;
    }

    public MoneyDetails getAmount() {
        return this.amount;
    }

    public void setAmount(MoneyDetails amount) {
        this.amount = amount;
    }

    public String getSenderNote() {
        return this.senderNote;
    }

    public void setSenderNote(String senderNote) {
        this.senderNote = senderNote;
    }

    public String getReceiverMessage() {
        return this.receiverMessage;
    }

    public void setReceiverMessage(String receiverMessage) {
        this.receiverMessage = receiverMessage;
    }

    @Override
    public QuoteId getQuoteId() {
        return this.quoteId;
    }

    @Override
    public void setQuoteId(QuoteId quoteId) {
        this.quoteId = quoteId;
    }

    public Coupon getCoupon() {
        return this.coupon;
    }

    public void setCoupon(Coupon coupon) {
        this.coupon = coupon;
    }

    public RequestReferenceId getRequestReferenceId() {
        return this.requestReferenceId;
    }

    public void setRequestReferenceId(RequestReferenceId requestReferenceId) {
        this.requestReferenceId = requestReferenceId;
    }
}

