/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.financial.v2_0.floattransfer;

import com.ericsson.em.m3if.financial.v1_0.quotation.QuoteRequest;
import com.ericsson.em.m3if.operations.validation.IsPositiveAmount;
import com.ericsson.em.m3if.provisioning.v1_0.common.IdentityValue;
import com.ericsson.em.m3if.v1_0.common.ExtensionType;
import com.ericsson.em.m3if.v1_0.common.FRIValue;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.m3if.v1_0.common.QuoteId;
import com.ericsson.em.validators.IsExternalReferenceString;
import com.ericsson.em.validators.IsRestrictedString;
import com.ericsson.em.validators.Length;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(namespace="http://www.ericsson.com/em/emm/financial/v2_0", name="floattransferrequest")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/financial/v2_0", name="", propOrder={"sendingFRI", "receivingIdentity", "amount", "senderNote", "receiverMessage", "referenceId", "extension", "quoteId"})
public class FloatTransferRequest
implements Serializable,
QuoteRequest {
    private static final long serialVersionUID = 1L;
    @Valid
    @XmlElement(name="sendingfri")
    private FRIValue sendingFRI;
    @Valid
    @NotNull
    @XmlElement(name="receivingidentity", required=true)
    private IdentityValue receivingIdentity;
    @Valid
    @NotNull
    @IsPositiveAmount
    @XmlElement(name="amount", required=true)
    private MoneyDetails amount;
    @Length(max=256)
    @IsRestrictedString
    @XmlElement(name="sendernote")
    private String senderNote;
    @Length(max=256)
    @IsRestrictedString
    @XmlElement(name="receivermessage")
    private String receiverMessage;
    @Length(min=1, max=64)
    @IsExternalReferenceString
    @XmlElement(name="referenceid")
    private String referenceId;
    @Valid
    @XmlElement(name="extension")
    private ExtensionType extension;
    @Valid
    @XmlElement(name="quoteid")
    private QuoteId quoteId;

    public FloatTransferRequest() {
    }

    public FloatTransferRequest(FRIValue from, String receivingIdentity, MoneyDetails amount) {
        this.setSendingFRI(from);
        this.setReceivingIdentity(receivingIdentity);
        this.setAmount(amount);
    }

    public FloatTransferRequest(FRIValue from, String receivingIdentity, MoneyDetails amount, String senderNote, String receiverMessage, String referenceId, ExtensionType extension) {
        this(from, receivingIdentity, amount);
        this.setSenderNote(senderNote);
        this.setReceiverMessage(receiverMessage);
        this.setReferenceId(referenceId);
        this.setExtension(extension);
    }

    public FRIValue getSendingFRI() {
        return this.sendingFRI;
    }

    public void setSendingFRI(FRIValue from) {
        this.sendingFRI = from;
    }

    public IdentityValue getReceivingIdentity() {
        return this.receivingIdentity;
    }

    public void setReceivingIdentity(IdentityValue to) {
        this.receivingIdentity = to;
    }

    public void setReceivingIdentity(String to) {
        this.receivingIdentity = new IdentityValue(to);
    }

    public MoneyDetails getAmount() {
        return this.amount;
    }

    public void setAmount(MoneyDetails amount) {
        this.amount = amount;
    }

    public String getSenderNote() {
        return this.senderNote;
    }

    public void setSenderNote(String senderNote) {
        this.senderNote = senderNote;
    }

    public String getReceiverMessage() {
        return this.receiverMessage;
    }

    public void setReceiverMessage(String receiverMessage) {
        this.receiverMessage = receiverMessage;
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    public ExtensionType getExtension() {
        return this.extension;
    }

    public void setExtension(ExtensionType extension) {
        this.extension = extension;
    }

    @Override
    public QuoteId getQuoteId() {
        return this.quoteId;
    }

    @Override
    public void setQuoteId(QuoteId quoteId) {
        this.quoteId = quoteId;
    }
}

